/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import si.nevensrok.common.objects.ObjectToString;

public class ConsoleOption {
    private String name;
    private Set<String> aliases;
    private boolean required = false;
    private int numberOfRequiredArguments = 0;
    private int numberOfAllArguments = 0;

    public ConsoleOption() {
    }

    public ConsoleOption(String name) {
        this.name = name;
    }

    public ConsoleOption(String name, Collection<String> aliases) {
        this.name = name;
        this.aliases = new LinkedHashSet<String>(aliases);
    }

    public ConsoleOption(String name, boolean required) {
        this.name = name;
        this.required = required;
    }

    public ConsoleOption(String name, Collection<String> aliases, boolean required) {
        this.name = name;
        this.aliases = new LinkedHashSet<String>(aliases);
        this.required = required;
    }

    public ConsoleOption(String name, boolean required, int numberOfRequiredArguments) {
        this.name = name;
        this.required = required;
        this.numberOfRequiredArguments = numberOfRequiredArguments;
        this.numberOfAllArguments = numberOfRequiredArguments;
    }

    public ConsoleOption(String name, Collection<String> aliases, boolean required, int numberOfRequiredArguments) {
        this.name = name;
        this.aliases = new LinkedHashSet<String>(aliases);
        this.required = required;
        this.numberOfRequiredArguments = numberOfRequiredArguments;
        this.numberOfAllArguments = numberOfRequiredArguments;
    }

    public ConsoleOption(String name, boolean required, int numberOfRequiredArguments, int numberOfAllArguments) {
        this.name = name;
        this.required = required;
        this.numberOfRequiredArguments = numberOfRequiredArguments;
        this.numberOfAllArguments = numberOfAllArguments;
    }

    public ConsoleOption(String name, Collection<String> aliases, boolean required, int numberOfRequiredArguments, int numberOfAllArguments) {
        this.name = name;
        this.aliases = new LinkedHashSet<String>(aliases);
        this.required = required;
        this.numberOfRequiredArguments = numberOfRequiredArguments;
        this.numberOfAllArguments = numberOfAllArguments;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public void addAliases(Collection<String> aliases) {
        if (this.aliases == null) {
            this.aliases = new LinkedHashSet<String>();
        }
        this.aliases.addAll(aliases);
    }

    public void addAliases(String ... aliases) {
        this.addAliases(Arrays.asList(aliases));
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getNumberOfRequiredArguments() {
        return this.numberOfRequiredArguments;
    }

    public void setNumberOfRequiredArguments(int numberOfRequiredArguments) {
        this.numberOfRequiredArguments = numberOfRequiredArguments;
    }

    public int getNumberOfAllArguments() {
        return this.numberOfAllArguments;
    }

    public void setNumberOfAllArguments(int numberOfAllArguments) {
        this.numberOfAllArguments = numberOfAllArguments;
    }

    public String toString() {
        return new ObjectToString(ConsoleOption.class).addProperty("name", (Object)this.name).addProperty("aliases", this.aliases).addProperty("required", this.required).addProperty("numberOfRequiredArguments", this.numberOfRequiredArguments).addProperty("numberOfAllArguments", this.numberOfAllArguments).generateString();
    }
}

