/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.jtekma.common.competition.CompetitionImport;
import si.nevensrok.jtekma.server.dl.dao.CompetitionImportDAO;
import si.nevensrok.jtekma.server.management.CompetitionImportManager;

public class CompetitionImportManagerImpl
implements CompetitionImportManager {
    private static final Logger log = LoggerFactory.getLogger(CompetitionImportManagerImpl.class);
    private CompetitionImportDAO competitionImportDAO;

    public void setCompetitionImportDAO(CompetitionImportDAO competitionImportDAO) {
        this.competitionImportDAO = competitionImportDAO;
    }

    @Transactional(value="jtekmaTransactionManager")
    public CompetitionImport createCompetitionImport(CompetitionImport competitionImport) {
        log.debug("Creating competition import: {}", (Object)competitionImport);
        return (CompetitionImport)this.competitionImportDAO.create((Pojo)competitionImport);
    }

    @Transactional(value="jtekmaTransactionManager")
    public CompetitionImport updateCompetitionImport(CompetitionImport competitionImport) {
        log.debug("Update competition import: {}", (Object)competitionImport);
        return (CompetitionImport)this.competitionImportDAO.update((Pojo)competitionImport);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteCompetitionImport(CompetitionImport competitionImport) {
        log.debug("Deleting competition import: {}", (Object)competitionImport);
        this.competitionImportDAO.delete((Pojo)competitionImport);
    }

    @Transactional(value="jtekmaTransactionManager")
    public CompetitionImport getById(Long competitionImportId) {
        return (CompetitionImport)this.competitionImportDAO.getById((Object)competitionImportId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<CompetitionImport> find(DataFilter dataFilter) {
        return this.competitionImportDAO.find(dataFilter, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void cleanupJobs() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -4);
        this.competitionImportDAO.cleanupJobs(calendar.getTime());
    }
}

