/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Objects;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> boolean isEmpty(T[] array) {
        if (array == null) {
            return true;
        }
        return array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static <T> boolean containsValue(T[] array, T value) {
        for (T val : array) {
            if (!Objects.equals(val, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> int countValues(T[] array, T value) {
        int count = 0;
        for (T val : array) {
            if (!Objects.equals(val, value)) continue;
            ++count;
        }
        return count;
    }

    public static boolean[] copyArray(boolean[] array) {
        if (array == null) {
            return null;
        }
        boolean[] copy = new boolean[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static byte[] copyArray(byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] copy = new byte[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static char[] copyArray(char[] array) {
        if (array == null) {
            return null;
        }
        char[] copy = new char[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static short[] copyArray(short[] array) {
        if (array == null) {
            return null;
        }
        short[] copy = new short[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static int[] copyArray(int[] array) {
        if (array == null) {
            return null;
        }
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static long[] copyArray(long[] array) {
        if (array == null) {
            return null;
        }
        long[] copy = new long[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static float[] copyArray(float[] array) {
        if (array == null) {
            return null;
        }
        float[] copy = new float[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static double[] copyArray(double[] array) {
        if (array == null) {
            return null;
        }
        double[] copy = new double[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static boolean[] subArray(boolean[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        boolean[] subArray = new boolean[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static byte[] subArray(byte[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        byte[] subArray = new byte[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static char[] subArray(char[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        char[] subArray = new char[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static short[] subArray(short[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        short[] subArray = new short[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static int[] subArray(int[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        int[] subArray = new int[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static long[] subArray(long[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        long[] subArray = new long[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static float[] subArray(float[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        float[] subArray = new float[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static double[] subArray(double[] array, int offset, int length) {
        if (array == null) {
            return null;
        }
        double[] subArray = new double[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static boolean[] toBooleanArray(Collection<Boolean> collection) {
        if (collection == null) {
            return null;
        }
        boolean[] array = new boolean[collection.size()];
        int i = 0;
        for (Boolean value : collection) {
            array[i++] = value;
        }
        return array;
    }

    public static byte[] toByteArray(Collection<Byte> collection) {
        if (collection == null) {
            return null;
        }
        byte[] array = new byte[collection.size()];
        int i = 0;
        for (Byte value : collection) {
            array[i++] = value;
        }
        return array;
    }

    public static char[] toCharArray(Collection<Character> collection) {
        if (collection == null) {
            return null;
        }
        char[] array = new char[collection.size()];
        int i = 0;
        for (Character value : collection) {
            array[i++] = value.charValue();
        }
        return array;
    }

    public static short[] toShortArray(Collection<Short> collection) {
        if (collection == null) {
            return null;
        }
        short[] array = new short[collection.size()];
        int i = 0;
        for (Short value : collection) {
            array[i++] = value;
        }
        return array;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        if (collection == null) {
            return null;
        }
        int[] array = new int[collection.size()];
        int i = 0;
        for (Integer value : collection) {
            array[i++] = value;
        }
        return array;
    }

    public static long[] toLongArray(Collection<Long> collection) {
        if (collection == null) {
            return null;
        }
        long[] array = new long[collection.size()];
        int i = 0;
        for (Long value : collection) {
            array[i++] = value;
        }
        return array;
    }

    public static float[] toFloatArray(Collection<Float> collection) {
        if (collection == null) {
            return null;
        }
        float[] array = new float[collection.size()];
        int i = 0;
        for (Float value : collection) {
            array[i++] = value.floatValue();
        }
        return array;
    }

    public static double[] toDoubleArray(Collection<Double> collection) {
        if (collection == null) {
            return null;
        }
        double[] array = new double[collection.size()];
        int i = 0;
        for (Double value : collection) {
            array[i++] = value;
        }
        return array;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        if (collection == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(clazz, collection.size());
        int i = 0;
        for (T value : collection) {
            array[i++] = value;
        }
        return array;
    }

    public static boolean areArraysEqual(boolean[] array1, boolean[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areArraysEqual(byte[] array1, byte[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areArraysEqual(char[] array1, char[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areArraysEqual(short[] array1, short[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areArraysEqual(int[] array1, int[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areArraysEqual(long[] array1, long[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areArraysEqual(float[] array1, float[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areArraysEqual(double[] array1, double[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean areArraysEqual(T[] array1, T[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Objects.equals(array1[i], array2[i])) continue;
            return false;
        }
        return true;
    }
}

