/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ListDataResult;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetesInCategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetitorDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CoupleCompetitorDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.PersonCompetitorDTO;

public class CompetitorDAO
extends ExtendedDao<Long, CompetitorDTO, Competitor> {
    private static final Logger log = LoggerFactory.getLogger(CompetitorDAO.class);

    public CompetitorDAO() {
        super(CompetitorDTO.class, Competitor.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("competitorId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("competition")) {
            return "competition.id";
        }
        if (fieldName.equalsIgnoreCase("club")) {
            return "club.id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("surname")) {
            return "surname";
        }
        if (fieldName.equalsIgnoreCase("shortName")) {
            return "shortName";
        }
        if (fieldName.equalsIgnoreCase("yearOfBirth")) {
            return "yearOfBirth";
        }
        if (fieldName.equalsIgnoreCase("weight")) {
            return "weight";
        }
        if (fieldName.equalsIgnoreCase("drawNumber")) {
            return "competesInCategory.drawNumber";
        }
        if (fieldName.equalsIgnoreCase("status")) {
            return "status";
        }
        if (fieldName.equalsIgnoreCase("type")) {
            return "type";
        }
        if (fieldName.equalsIgnoreCase("name1")) {
            return "name1";
        }
        if (fieldName.equalsIgnoreCase("surname1")) {
            return "surname1";
        }
        if (fieldName.equalsIgnoreCase("name2")) {
            return "name2";
        }
        if (fieldName.equalsIgnoreCase("surname2")) {
            return "surname2";
        }
        if (fieldName.equalsIgnoreCase("yearOfBirth1")) {
            return "yearOfBirth1";
        }
        if (fieldName.equalsIgnoreCase("yearOfBirth2")) {
            return "yearOfBirth2";
        }
        if (fieldName.equalsIgnoreCase("club.name")) {
            return "club.name";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public void addCompetitorToCategory(Competitor competitor, Category category) {
        CategoryDTO categoryDTO = new CategoryDTO();
        categoryDTO.setCategoryId(category.getCategoryId());
        CompetitorDTO competitorDTO = new CompetitorDTO();
        competitorDTO.setCompetitorId(competitor.getCompetitorId());
        CompetesInCategoryDTO competesInCategoryDTO = new CompetesInCategoryDTO(categoryDTO, competitorDTO);
        competesInCategoryDTO.setDrawNumber(null);
        this.getCurrentSession().saveOrUpdate((Object)competesInCategoryDTO);
        this.flush();
    }

    public void removeCompetitorFromCategory(Competitor competitor, Category category) {
        CategoryDTO categoryDTO = new CategoryDTO();
        categoryDTO.setCategoryId(category.getCategoryId());
        CompetitorDTO competitorDTO = new CompetitorDTO();
        competitorDTO.setCompetitorId(competitor.getCompetitorId());
        CompetesInCategoryDTO competesInCategoryDTO = new CompetesInCategoryDTO(categoryDTO, competitorDTO);
        this.getCurrentSession().delete((Object)competesInCategoryDTO);
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set competitor1=null where category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and competitor1.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("update MatchDTO set competitor2=null where category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and competitor2.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCompetitorCategories(Competitor competitor, Set<Category> categories) {
        Category category;
        HashSet<Long> newCategories = new HashSet<Long>();
        for (Category category2 : categories) {
            newCategories.add(category2.getCategoryId());
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("from CompetesInCategoryDTO where competesInCategoryKey.competitor.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List currentList = query.getResultList();
        HashSet categoriesToAdd = new HashSet(newCategories);
        HashSet<Long> categoriesToRemove = new HashSet<Long>();
        for (Object item : currentList) {
            CompetesInCategoryDTO competesInCategoryDTO = (CompetesInCategoryDTO)item;
            Long categoryId = competesInCategoryDTO.getCompetesInCategoryKey().getCategory().getCategoryId();
            if (newCategories.contains(categoryId)) {
                categoriesToAdd.remove(categoryId);
                continue;
            }
            categoriesToRemove.add(categoryId);
        }
        this.flush();
        for (Long categoryId : categoriesToAdd) {
            category = new Category();
            category.setCategoryId(categoryId);
            this.addCompetitorToCategory(competitor, category);
        }
        for (Long categoryId : categoriesToRemove) {
            category = new Category();
            category.setCategoryId(categoryId);
            this.removeCompetitorFromCategory(competitor, category);
        }
    }

    public List<Competitor> getCompetitorsForCategory(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getCompetitorsForCategory(Category category, Competitor.Type competitorType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        sqlQuery.append(" and competesInCategory.competesInCategoryKey.competitor.type=");
        sqlQuery.append(params.addParam((Object)competitorType));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getCompetitorsForClub(Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.club.clubId=");
        sqlQuery.append(params.addParam(club.getClubId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getCompetitorsForClub(Club club, Competitor.Type competitorType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.club.clubId=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" and competitor.type=");
        sqlQuery.append(params.addParam((Object)competitorType));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public PageDataResult<Competitor> findForCompetition(Competition competition, DataFilter dataFilter) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("from CompetitorDTO as main where main.competition=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        if (dataFilter.getFilter() != null) {
            StringBuilder filterQuery = new StringBuilder();
            try {
                this.addFilter(filterQuery, params, dataFilter.getFilter(), false);
            }
            catch (Exception e) {
                log.error("Error adding filters", (Throwable)e);
            }
            if (filterQuery.length() > 0) {
                sqlQuery.append(" and");
                sqlQuery.append((CharSequence)filterQuery);
            }
        }
        Query query = this.createQuery("select count(main) " + sqlQuery.toString());
        params.bindParams(query);
        Long totalRowCount = Long.parseLong(CompetitorDAO.getSingleResult((Query)query).toString());
        try {
            this.addSort(sqlQuery, dataFilter.getSort());
        }
        catch (Exception e) {
            log.error("Error adding sort conditions", (Throwable)e);
        }
        query = this.createQuery("select main,main.club " + sqlQuery.toString());
        params.bindParams(query);
        if (dataFilter.getStartIndex() != null) {
            query.setFirstResult(dataFilter.getStartIndex().intValue());
        }
        if (dataFilter.getItemLimit() != null) {
            query.setMaxResults(dataFilter.getItemLimit().intValue());
        }
        List result = query.getResultList();
        LinkedList<Competitor> list = new LinkedList<Competitor>();
        for (Object item : result) {
            Object[] parts = (Object[])item;
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, parts[0]);
            competitor.setClub((Club)this.getAdapterPool().create(Club.class, parts[1]));
            list.add(competitor);
        }
        ListDataResult dataResult = new ListDataResult();
        dataResult.setData(list);
        dataResult.setTotalCount(totalRowCount);
        dataResult.setDisplayItemsPerPage(dataFilter.getItemLimit());
        this.flush();
        return dataResult;
    }

    public void changeCompetitorStatus(Competitor competitor, Competitor.Status status) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update CompetitorDTO set status=");
        sqlQuery.append(params.addParam((Object)status));
        sqlQuery.append(" where id=");
        sqlQuery.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCompetitorsClub(Competitor competitor, Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update CompetitorDTO set club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" where id=");
        sqlQuery.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public PersonCompetitor getActivePersonCompetitorByNameAndClub(Competition competition, String firstName, String lastName, Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from PersonCompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and UPPER(competitor.name)=UPPER(");
        sqlQuery.append(params.addParam(firstName));
        sqlQuery.append(") and UPPER(competitor.surname)=UPPER(");
        sqlQuery.append(params.addParam(lastName));
        sqlQuery.append(") and competitor.club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        PersonCompetitorDTO personCompetitorDTO = (PersonCompetitorDTO)CompetitorDAO.getSingleResult((Query)query);
        PersonCompetitor personCompetitor = null;
        if (personCompetitorDTO != null) {
            personCompetitor = (PersonCompetitor)this.getAdapterPool().create(PersonCompetitor.class, (Object)personCompetitorDTO);
        }
        this.flush();
        return personCompetitor;
    }

    public CoupleCompetitor getActiveCoupleCompetitorByNameAndClub(Competition competition, String firstName1, String lastName1, String firstName2, String lastName2, Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CoupleCompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and UPPER(competitor.name1)=UPPER(");
        sqlQuery.append(params.addParam(firstName1));
        sqlQuery.append(") and UPPER(competitor.surname1)=UPPER(");
        sqlQuery.append(params.addParam(lastName1));
        sqlQuery.append(") and UPPER(competitor.name2)=UPPER(");
        sqlQuery.append(params.addParam(firstName2));
        sqlQuery.append(") and UPPER(competitor.surname2)=UPPER(");
        sqlQuery.append(params.addParam(lastName2));
        sqlQuery.append(") and competitor.club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CoupleCompetitorDTO coupleCompetitorDTO = (CoupleCompetitorDTO)CompetitorDAO.getSingleResult((Query)query);
        CoupleCompetitor coupleCompetitor = null;
        if (coupleCompetitorDTO != null) {
            coupleCompetitor = (CoupleCompetitor)this.getAdapterPool().create(CoupleCompetitor.class, (Object)coupleCompetitorDTO);
        }
        this.flush();
        return coupleCompetitor;
    }

    public List<Competitor> getCompetitorsForCompetiton(Competition competition, Competitor.Type type, int minumumMatchCount) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and competitor.type=");
        sqlQuery.append(params.addParam((Object)type));
        sqlQuery.append(" and (select count(*) from MatchDTO as match where (match.competitor1.id=competitor.id or match.competitor2.id=competitor.id) and match.status=");
        sqlQuery.append(params.addParam((Object)Match.Status.FINISHED));
        sqlQuery.append(")>=");
        sqlQuery.append(params.addParam(Integer.valueOf(minumumMatchCount)));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (CompetitorDTO competitorDTO : list) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, (Object)competitorDTO);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public void removeCompetitorFromAllCategories(Competitor competitor) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from CompetesInCategoryDTO where competesInCategoryKey.competitor.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("update MatchDTO set competitor1=null where competitor1.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("update MatchDTO set competitor2=null where competitor2.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public List<Competitor> getActiveCompetitorsForCompetition(Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (CompetitorDTO competitorDTO : list) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, (Object)competitorDTO);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getActiveCompetitorsForCompetition(Competition competition, Competitor.Type competitorType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        sqlQuery.append(" and competitor.type=");
        sqlQuery.append(params.addParam((Object)competitorType));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (CompetitorDTO competitorDTO : list) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, (Object)competitorDTO);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }
}

