/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.tools;

import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.common.mail.Email;
import si.nevensrok.common.mail.MailSender;
import si.nevensrok.common.textrenderer.TextRenderer;
import si.nevensrok.jtekma.common.system.User;

public class EmailSenderTool
implements ApplicationContextAware {
    private Logger log = LoggerFactory.getLogger(EmailSenderTool.class);
    private ApplicationContext applicationContext;
    private TextRenderer emailTextRenderer;
    private MailSender mailSender;
    private String senderAddress;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEmailTextRenderer(TextRenderer emailTextRenderer) {
        this.emailTextRenderer = emailTextRenderer;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    public String getLanguageText(Locale locale, String key) {
        return this.applicationContext.getMessage(key, null, key, locale);
    }

    public String getLanguageText(Locale locale, String key, Object[] args) {
        return this.applicationContext.getMessage(key, args, key, locale);
    }

    public void sendRecoverPasswordMail(Locale locale, User user, String token) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending recover password mail to user {}", (Object)user);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", token);
        data.put("user", (String)user);
        String html = this.emailTextRenderer.renderText("recover-password-email", data, locale);
        Email email = new Email(this.senderAddress, user.getEmail(), this.getLanguageText(locale, "recoverPassword.email.subject"), html);
        this.mailSender.sendEmail(email);
    }
}

