/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.security;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import si.nevensrok.common.web.security.UserData;
import si.nevensrok.common.web.security.UserDatabase;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.management.UserManager;
import si.nevensrok.jtekma.server.web.security.LoginUserInfo;
import si.nevensrok.jtekma.server.web.security.UserDetails;

public class UserRepository
implements UserDetailsService,
UserDatabase {
    private static final Logger log = LoggerFactory.getLogger(UserRepository.class);
    private UserManager userManager;

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public UserData getUserByUsernameAndPassword(String username, String password) {
        User user = this.userManager.getUserByUsername(username);
        if (user == null) {
            return null;
        }
        if (user.getStatus() != User.Status.ACTIVE) {
            return null;
        }
        if (!this.userManager.checkPassword(password, user.getPassword())) {
            return null;
        }
        return new LoginUserInfo(user);
    }

    public UserData getUserByUsername(String username) {
        User user = this.userManager.getUserByUsername(username);
        if (user == null) {
            return null;
        }
        if (user.getStatus() != User.Status.ACTIVE) {
            return null;
        }
        return new LoginUserInfo(user);
    }

    public List<GrantedAuthority> getGrantedAuthoritys(UserData userData) {
        LoginUserInfo loginUserInfo = (LoginUserInfo)userData;
        LinkedList<GrantedAuthority> grantedAuthoritys = new LinkedList<GrantedAuthority>();
        if (loginUserInfo.getUser().getIsSuperAdmin().booleanValue()) {
            grantedAuthoritys.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_ADMIN"));
        }
        grantedAuthoritys.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        return grantedAuthoritys;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("Loading user details for username {}", (Object)username);
        }
        User user = this.userManager.getUserByUsername(username);
        UserDetails userDetails = null;
        if (user != null) {
            userDetails = new UserDetails();
            userDetails.setUsername(user.getUsername());
            userDetails.setEnabled(user.getStatus() == User.Status.ACTIVE);
            userDetails.setCredentialsExpired(false);
            userDetails.setExpired(false);
            userDetails.setLocked(false);
            userDetails.getAuthorities().add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        }
        return userDetails;
    }
}

