/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.formatter;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import si.nevensrok.jtekma.server.web.formatter.FightTimeFormatter;

public class FightTimeAnnotationFormatterFactory
implements AnnotationFormatterFactory<FightTimeFormatter> {
    private final Set<Class<?>> fieldTypes;

    public FightTimeAnnotationFormatterFactory() {
        HashSet<Class<Integer>> rawFieldTypes = new HashSet<Class<Integer>>(7);
        rawFieldTypes.add(Integer.class);
        this.fieldTypes = Collections.unmodifiableSet(rawFieldTypes);
    }

    public Set<Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    public Printer<Integer> getPrinter(FightTimeFormatter annotation, Class<?> fieldType) {
        return new Printer<Integer>(){

            public String print(Integer fightTime, Locale locale) {
                int minutes = fightTime / 60;
                int seconds = fightTime % 60;
                return (minutes < 10 ? "0" : "") + String.valueOf(minutes) + ":" + (seconds < 10 ? "0" : "") + String.valueOf(seconds);
            }
        };
    }

    public Parser<Integer> getParser(FightTimeFormatter annotation, Class<?> fieldType) {
        return new Parser<Integer>(){

            public Integer parse(String text, Locale locale) throws ParseException {
                String[] parts = text.split(":");
                int minutes = 0;
                int seconds = 0;
                if (parts.length > 1) {
                    minutes = Integer.parseInt(parts[0]);
                    seconds = Integer.parseInt(parts[1]);
                } else {
                    seconds = Integer.parseInt(parts[0]);
                }
                return minutes * 60 + seconds;
            }
        };
    }
}

