/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging;

import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import si.nevensrok.common.logging.LogItem;

public abstract class AbstractBackgroundAppender
extends AppenderSkeleton {
    private String machineName = null;
    private boolean closed = false;
    private boolean debug = false;
    private Object logItemMonitor = new Object();
    private LinkedList<LogItem> logItems = new LinkedList();

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void activateOptions() {
        block2: {
            try {
                this.connect();
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                e.printStackTrace();
            }
        }
        Thread thread = new Thread("Background logger thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block13: while (true) {
                    try {
                        while (!AbstractBackgroundAppender.this.closed) {
                            String processName;
                            String machineHostname;
                            String machineIp6;
                            String machineIp4;
                            LogItem logItem;
                            block21: {
                                block20: {
                                    Object object = AbstractBackgroundAppender.this.logItemMonitor;
                                    synchronized (object) {
                                        while (AbstractBackgroundAppender.this.logItems.isEmpty() && !AbstractBackgroundAppender.this.closed) {
                                            try {
                                                AbstractBackgroundAppender.this.logItemMonitor.wait();
                                            }
                                            catch (Exception exception) {}
                                        }
                                        if (AbstractBackgroundAppender.this.closed) {
                                            return;
                                        }
                                        logItem = (LogItem)AbstractBackgroundAppender.this.logItems.removeFirst();
                                    }
                                    machineIp4 = null;
                                    machineIp6 = null;
                                    machineHostname = null;
                                    processName = ManagementFactory.getRuntimeMXBean().getName();
                                    try {
                                        machineHostname = InetAddress.getLocalHost().getHostName();
                                    }
                                    catch (Exception e) {
                                        if (!AbstractBackgroundAppender.this.debug) break block20;
                                        e.printStackTrace();
                                    }
                                }
                                try {
                                    Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
                                    while (networkInterfaceEnumerator.hasMoreElements()) {
                                        NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                                        if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                                        Enumeration<InetAddress> addressEnumerator = networkInterface.getInetAddresses();
                                        while (addressEnumerator.hasMoreElements()) {
                                            InetAddress address = addressEnumerator.nextElement();
                                            if (address instanceof Inet4Address) {
                                                Inet4Address inet4Address = (Inet4Address)address;
                                                machineIp4 = inet4Address.getHostAddress();
                                                continue;
                                            }
                                            if (!(address instanceof Inet6Address)) continue;
                                            Inet6Address inet6Address = (Inet6Address)address;
                                            machineIp6 = inet6Address.getHostAddress();
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    if (!AbstractBackgroundAppender.this.debug) break block21;
                                    e.printStackTrace();
                                }
                            }
                            logItem.setMachineIp4(machineIp4);
                            logItem.setMachineIp6(machineIp6);
                            logItem.setMachineHostname(machineHostname);
                            logItem.setProcessName(processName);
                            logItem.setMachineName(AbstractBackgroundAppender.this.machineName);
                            try {
                                AbstractBackgroundAppender.this.logItem(logItem);
                                continue block13;
                            }
                            catch (Exception e) {
                                if (!AbstractBackgroundAppender.this.debug) continue;
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (!AbstractBackgroundAppender.this.debug) break;
                        e.printStackTrace();
                        break;
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void close() {
        block2: {
            this.closed = true;
            try {
                this.disconnect();
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                e.printStackTrace();
            }
        }
        this.logItems.clear();
    }

    public void finalize() {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        LogItem logItem = new LogItem();
        logItem.setLoggingEvent(event);
        logItem.setTimeStamp(event.getTimeStamp());
        logItem.setThreadName(event.getThreadName());
        logItem.setCategory(event.getLogger().getName());
        logItem.setLevel(event.getLevel().toString());
        logItem.setMessage(event.getRenderedMessage());
        logItem.setThrowable(this.getThrowableText(event.getThrowableStrRep()));
        logItem.setLocationClassName(event.getLocationInformation().getClassName());
        logItem.setLocationMethodName(event.getLocationInformation().getMethodName());
        logItem.setLocationLineNumber(event.getLocationInformation().getLineNumber());
        Object object = this.logItemMonitor;
        synchronized (object) {
            this.logItems.add(logItem);
            this.logItemMonitor.notifyAll();
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public String getMachineName() {
        return this.machineName;
    }

    private String getThrowableText(String[] throwable) {
        if (throwable == null) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        for (String line : throwable) {
            if (line.length() > 0) {
                text.append("\n");
            }
            text.append(line);
        }
        return text.toString();
    }

    public abstract void connect();

    public abstract void disconnect();

    public abstract void logItem(LogItem var1);
}

