/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.common.tatami.TatamiFightOrder;
import si.nevensrok.jtekma.fightinfo.gui.TatamiFightList;

public class NextFightsPanel
extends JPanel {
    private static final long serialVersionUID = 9134935301950268402L;
    private Map<Long, TatamiFightList> tatamiFightLists = new HashMap<Long, TatamiFightList>();
    private JTabbedPane tatamiTabbedPane;

    public NextFightsPanel() {
        this.setLayout(new BorderLayout());
        this.tatamiTabbedPane = new JTabbedPane();
        this.add((Component)this.tatamiTabbedPane, "Center");
    }

    public void updateTatamiNextFights(final TatamiFightData tatamiFightData) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashSet unusedTatamis = new HashSet();
                for (TatamiFightOrder tatamiFightOrder : tatamiFightData.getTatamiFightOrders()) {
                    Long tatamiId = tatamiFightOrder.getTatami().getTatamiId();
                    TatamiFightList tatamiFightList = (TatamiFightList)NextFightsPanel.this.tatamiFightLists.get(tatamiId);
                    if (tatamiFightList == null) {
                        tatamiFightList = new TatamiFightList();
                        NextFightsPanel.this.tatamiFightLists.put(tatamiId, tatamiFightList);
                        NextFightsPanel.this.tatamiTabbedPane.add(tatamiFightOrder.getTatami().getDisplayText(), tatamiFightList);
                    } else {
                        unusedTatamis.remove(tatamiId);
                    }
                    tatamiFightList.updateFightOrder(tatamiFightOrder.getFightOrders());
                }
                for (Long tatamiId : unusedTatamis) {
                    TatamiFightList tatamiFightList = (TatamiFightList)NextFightsPanel.this.tatamiFightLists.remove(tatamiId);
                    NextFightsPanel.this.tatamiTabbedPane.remove(tatamiFightList);
                }
                NextFightsPanel.this.revalidate();
                NextFightsPanel.this.repaint();
            }
        });
    }
}

