/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchDetail;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.fightinfo.common.FightWindowData;

public class FightDataMiniWindow
extends JDialog {
    private static final long serialVersionUID = -473464939787329038L;
    private static final NumberFormat fightPointsFormat = new DecimalFormat("0", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final NumberFormat duoPointsFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final Color competitor1fgColor = Color.WHITE;
    private static final Color competitor1bgColor = new Color(0xC00000);
    private static final Color competitor2fgColor = Color.WHITE;
    private static final Color competitor2bgColor = new Color(192);
    private JLabel timeLabel = new JLabel();
    private JPanel competitor1Panel = new JPanel();
    private JLabel competitor1Name = new JLabel();
    private JLabel competitor1Points = new JLabel();
    private JPanel competitor2Panel = new JPanel();
    private JLabel competitor2Name = new JLabel();
    private JLabel competitor2Points = new JLabel();
    private boolean flipSides = false;

    public FightDataMiniWindow() {
        this.setDefaultCloseOperation(0);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FightDataMiniWindow.this.setFocusable(false);
                FightDataMiniWindow.this.setFocusableWindowState(false);
                FightDataMiniWindow.this.setUndecorated(true);
                FightDataMiniWindow.this.setLayout(new BorderLayout());
                FightDataMiniWindow.this.timeLabel.setOpaque(true);
                FightDataMiniWindow.this.timeLabel.setBackground(Color.WHITE);
                FightDataMiniWindow.this.timeLabel.setHorizontalAlignment(0);
                FightDataMiniWindow.this.add((Component)FightDataMiniWindow.this.timeLabel, "Center");
                FightDataMiniWindow.this.competitor1Panel.setLayout(new BorderLayout());
                FightDataMiniWindow.this.add((Component)FightDataMiniWindow.this.competitor1Panel, "West");
                FightDataMiniWindow.this.competitor1Name.setHorizontalAlignment(4);
                FightDataMiniWindow.this.competitor1Name.setBorder(new EmptyBorder(2, 2, 2, 2));
                FightDataMiniWindow.this.competitor1Name.setForeground(competitor1fgColor);
                FightDataMiniWindow.this.competitor1Panel.add((Component)FightDataMiniWindow.this.competitor1Name, "West");
                FightDataMiniWindow.this.competitor1Points.setHorizontalAlignment(4);
                FightDataMiniWindow.this.competitor1Points.setBorder(new EmptyBorder(2, 2, 2, 2));
                FightDataMiniWindow.this.competitor1Points.setForeground(competitor1fgColor);
                FightDataMiniWindow.this.competitor1Panel.add((Component)FightDataMiniWindow.this.competitor1Points, "Center");
                FightDataMiniWindow.this.competitor2Panel.setLayout(new BorderLayout());
                FightDataMiniWindow.this.add((Component)FightDataMiniWindow.this.competitor2Panel, "East");
                FightDataMiniWindow.this.competitor2Name.setHorizontalAlignment(2);
                FightDataMiniWindow.this.competitor2Name.setBorder(new EmptyBorder(2, 2, 2, 2));
                FightDataMiniWindow.this.competitor2Name.setForeground(competitor2fgColor);
                FightDataMiniWindow.this.competitor2Panel.add((Component)FightDataMiniWindow.this.competitor2Name, "East");
                FightDataMiniWindow.this.competitor2Points.setHorizontalAlignment(2);
                FightDataMiniWindow.this.competitor2Points.setBorder(new EmptyBorder(2, 2, 2, 2));
                FightDataMiniWindow.this.competitor2Points.setForeground(competitor2fgColor);
                FightDataMiniWindow.this.competitor2Panel.add((Component)FightDataMiniWindow.this.competitor2Points, "Center");
            }
        });
    }

    public void updateLocationAndSize(final FightWindowData fightWindowData) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FightDataMiniWindow.this.setLocation(fightWindowData.getLocation().width, fightWindowData.getLocation().height);
                FightDataMiniWindow.this.setSize(fightWindowData.getSize().width, fightWindowData.getSize().height);
                FightDataMiniWindow.this.timeLabel.setPreferredSize(new Dimension((int)((double)fightWindowData.getSize().width * 0.1), 0));
                FightDataMiniWindow.this.timeLabel.setFont(new Font("Serif", 1, fightWindowData.getFontSize()));
                int competitorPanelWidth = (int)((double)fightWindowData.getSize().width * 0.45);
                FightDataMiniWindow.this.competitor1Panel.setPreferredSize(new Dimension(competitorPanelWidth, 0));
                FightDataMiniWindow.this.competitor1Name.setPreferredSize(new Dimension((int)((double)competitorPanelWidth * 0.8), 0));
                FightDataMiniWindow.this.competitor1Name.setFont(new Font("Serif", 1, fightWindowData.getFontSize()));
                FightDataMiniWindow.this.competitor1Points.setPreferredSize(new Dimension((int)((double)competitorPanelWidth * 0.2), 0));
                FightDataMiniWindow.this.competitor1Points.setFont(new Font("Serif", 1, fightWindowData.getFontSize()));
                FightDataMiniWindow.this.competitor2Panel.setPreferredSize(new Dimension(competitorPanelWidth, 0));
                FightDataMiniWindow.this.competitor2Name.setPreferredSize(new Dimension((int)((double)competitorPanelWidth * 0.8), 0));
                FightDataMiniWindow.this.competitor2Name.setFont(new Font("Serif", 1, fightWindowData.getFontSize()));
                FightDataMiniWindow.this.competitor2Points.setPreferredSize(new Dimension((int)((double)competitorPanelWidth * 0.2), 0));
                FightDataMiniWindow.this.competitor2Points.setFont(new Font("Serif", 1, fightWindowData.getFontSize()));
                FightDataMiniWindow.this.flipSides = fightWindowData.isFlipSides();
                if (!FightDataMiniWindow.this.flipSides) {
                    FightDataMiniWindow.this.competitor1Panel.setBackground(competitor1bgColor);
                    FightDataMiniWindow.this.competitor2Panel.setBackground(competitor2bgColor);
                } else {
                    FightDataMiniWindow.this.competitor1Panel.setBackground(competitor2bgColor);
                    FightDataMiniWindow.this.competitor2Panel.setBackground(competitor1bgColor);
                }
                FightDataMiniWindow.this.setVisible(true);
            }
        });
    }

    public void updateContent(MatchDetail matchDetail, String rules, RulesManager rulesManager) {
        if (matchDetail == null || matchDetail.getMatch() == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FightDataMiniWindow.this.timeLabel.setText("");
                    FightDataMiniWindow.this.competitor1Name.setText("");
                    FightDataMiniWindow.this.competitor1Points.setText("");
                    FightDataMiniWindow.this.competitor2Name.setText("");
                    FightDataMiniWindow.this.competitor2Points.setText("");
                }
            });
        } else {
            String fightTimeLeftText;
            String points2Text;
            String points1Text;
            Competitor competitor2;
            Match match = matchDetail.getMatch();
            String competitor1Text = "";
            String competitor2Text = "";
            Competitor competitor1 = match.getCompetitor1();
            if (competitor1 != null) {
                if (competitor1 instanceof PersonCompetitor) {
                    PersonCompetitor personCompetitor = (PersonCompetitor)competitor1;
                    competitor1Text = personCompetitor.getShortName();
                }
                if (competitor1 instanceof CoupleCompetitor) {
                    CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor1;
                    competitor1Text = coupleCompetitor.getShortName();
                }
                competitor1Text = competitor1Text + "/" + competitor1.getClub().getShortName();
            }
            if ((competitor2 = match.getCompetitor2()) != null) {
                if (competitor2 instanceof PersonCompetitor) {
                    PersonCompetitor personCompetitor = (PersonCompetitor)competitor2;
                    competitor2Text = personCompetitor.getShortName();
                }
                if (competitor2 instanceof CoupleCompetitor) {
                    CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor2;
                    competitor2Text = coupleCompetitor.getShortName();
                }
                competitor2Text = competitor2Text + "/" + competitor2.getClub().getShortName();
            }
            final String c1t = competitor1Text;
            final String c2t = competitor2Text;
            if (!this.flipSides) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FightDataMiniWindow.this.competitor1Name.setText(c1t);
                        FightDataMiniWindow.this.competitor2Name.setText(c2t);
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FightDataMiniWindow.this.competitor1Name.setText(c2t);
                        FightDataMiniWindow.this.competitor2Name.setText(c1t);
                    }
                });
            }
            CompetitionRules competitionRules = rulesManager.getCompetitionRules(rules);
            if (competitionRules != null) {
                float points1 = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, matchDetail.getMatchPoints());
                float points2 = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, matchDetail.getMatchPoints());
                if (match.getType() == Match.Type.FIGHT || match.getType() == Match.Type.NEWAZA) {
                    points1Text = fightPointsFormat.format(points1);
                    points2Text = fightPointsFormat.format(points2);
                } else if (match.getType() == Match.Type.DUO) {
                    points1Text = duoPointsFormat.format(points1);
                    points2Text = duoPointsFormat.format(points2);
                } else {
                    points1Text = "";
                    points2Text = "";
                }
            } else {
                points1Text = "";
                points2Text = "";
            }
            if (!this.flipSides) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FightDataMiniWindow.this.competitor1Points.setText(points1Text);
                        FightDataMiniWindow.this.competitor2Points.setText(points2Text);
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FightDataMiniWindow.this.competitor1Points.setText(points2Text);
                        FightDataMiniWindow.this.competitor2Points.setText(points1Text);
                    }
                });
            }
            Integer fightTimeLeft = match.getFightTimeLeft();
            if (fightTimeLeft != null) {
                int minutes = fightTimeLeft / 60;
                int seconds = fightTimeLeft % 60;
                fightTimeLeftText = String.valueOf(minutes) + ":" + (seconds < 10 ? "0" : "") + String.valueOf(seconds);
            } else {
                fightTimeLeftText = "";
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FightDataMiniWindow.this.timeLabel.setText(fightTimeLeftText);
                }
            });
        }
    }
}

