/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;

public class SettingsDialog
extends JDialog
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = 7443312068356111292L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsDialog.class);
    private NumberFormat secondsNumberFormat = new DecimalFormat("00");
    private ApplicationContext applicationContext;
    private MatchData matchData;
    private TablaWindow tablaWindow;
    private RulesManager rulesManager;
    private TablaManager tablaManager;
    private JButton saveButton = new JButton("Save");
    private JButton cancelButton = new JButton("Cancel");
    private JLabel matchTimeLabel = new JLabel("Default match time");
    private JTextField matchTimeField = new JTextField();
    private JLabel hosekomiTimeLabel = new JLabel("Hosekomi time");
    private JTextField hosekomiTimeField = new JTextField();
    private JLabel newazaHansokumakePenaltiesLabel = new JLabel("Ne waza hansokumake penalties");
    private JTextField newazaHansokumakePenaltiesField = new JTextField();
    private JLabel rulesLabel = new JLabel("Rules");
    private JComboBox<String> rulesComboBox = new JComboBox();
    private JLabel languageLabel = new JLabel("Language");
    private JComboBox<String> languagesComboBox = new JComboBox();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaWindow(TablaWindow tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public void afterPropertiesSet() throws Exception {
        final List rules = this.rulesManager.getAvailableCompetitionRules();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultComboBoxModel comboBoxModel;
                if (SettingsDialog.this.rulesComboBox.getModel() instanceof DefaultComboBoxModel) {
                    comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.rulesComboBox.getModel();
                    for (String rule : rules) {
                        comboBoxModel.addElement(rule);
                    }
                }
                if (SettingsDialog.this.languagesComboBox.getModel() instanceof DefaultComboBoxModel) {
                    comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.languagesComboBox.getModel();
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("locale.english"));
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("locale.slovenian"));
                }
            }
        });
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsDialog.this.setVisible(false);
                SettingsDialog.this.dispose();
            }
        });
    }

    public SettingsDialog() {
        this.setAlwaysOnTop(true);
        this.setSize(600, 230);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        JPanel settingsPanel = new JPanel();
        this.add((Component)settingsPanel, "Center");
        settingsPanel.setLayout(new GridLayout(5, 1));
        JPanel matchTimePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(matchTimePanel);
        matchTimePanel.add(this.matchTimeLabel);
        matchTimePanel.add(this.matchTimeField);
        this.matchTimeLabel.setPreferredSize(new Dimension(290, 20));
        this.matchTimeField.setPreferredSize(new Dimension(200, 20));
        JPanel hosekomiTimePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(hosekomiTimePanel);
        hosekomiTimePanel.add(this.hosekomiTimeLabel);
        hosekomiTimePanel.add(this.hosekomiTimeField);
        this.hosekomiTimeLabel.setPreferredSize(new Dimension(290, 20));
        this.hosekomiTimeField.setPreferredSize(new Dimension(200, 20));
        JPanel newazaHansokumakePenaltiesPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(newazaHansokumakePenaltiesPanel);
        newazaHansokumakePenaltiesPanel.add(this.newazaHansokumakePenaltiesLabel);
        newazaHansokumakePenaltiesPanel.add(this.newazaHansokumakePenaltiesField);
        this.newazaHansokumakePenaltiesLabel.setPreferredSize(new Dimension(290, 20));
        this.newazaHansokumakePenaltiesField.setPreferredSize(new Dimension(200, 20));
        JPanel rulesPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(rulesPanel);
        rulesPanel.add(this.rulesLabel);
        rulesPanel.add(this.rulesComboBox);
        this.rulesLabel.setPreferredSize(new Dimension(290, 20));
        this.rulesComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel languagePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(languagePanel);
        languagePanel.add(this.languageLabel);
        languagePanel.add(this.languagesComboBox);
        this.languageLabel.setPreferredSize(new Dimension(290, 20));
        this.languagesComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 20, 10));
        this.add((Component)buttonsPanel, "South");
        buttonsPanel.add(this.saveButton);
        buttonsPanel.add(this.cancelButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String hosekomiTimeText;
                String timeText = SettingsDialog.this.matchTimeField.getText().trim();
                if (!timeText.isEmpty()) {
                    try {
                        String[] parts = timeText.split(":");
                        long minutes = 0L;
                        long seconds = 0L;
                        if (parts.length > 1) {
                            minutes = Long.parseLong(parts[0].trim());
                            seconds = Long.parseLong(parts[1].trim());
                        } else {
                            minutes = 0L;
                            seconds = Long.parseLong(parts[0].trim());
                        }
                        SettingsDialog.this.matchData.setDefaultMatchTime((minutes * 60L + seconds) * 1000L);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while parsing match time", (Throwable)ex);
                    }
                }
                if (!(hosekomiTimeText = SettingsDialog.this.hosekomiTimeField.getText()).isEmpty()) {
                    try {
                        long seconds = Long.parseLong(hosekomiTimeText);
                        SettingsDialog.this.matchData.setMaximumHosekomiTime(seconds * 1000L);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while parsing hosekomi time", (Throwable)ex);
                    }
                }
                try {
                    int penalties = Integer.parseInt(SettingsDialog.this.newazaHansokumakePenaltiesField.getText());
                    SettingsDialog.this.matchData.setNewazaPenaltyHansokumake(penalties);
                }
                catch (Exception ex) {
                    LOGGER.error("Error while parsing ne waza hansokumake penalties", (Throwable)ex);
                }
                SettingsDialog.this.matchData.setRules((String)SettingsDialog.this.rulesComboBox.getSelectedItem());
                if (SettingsDialog.this.languagesComboBox.getSelectedIndex() == 0) {
                    SettingsDialog.this.matchData.setLocale(new Locale("en"));
                } else if (SettingsDialog.this.languagesComboBox.getSelectedIndex() == 1) {
                    SettingsDialog.this.matchData.setLocale(new Locale("sl"));
                }
                SettingsDialog.this.setVisible(false);
                SettingsDialog.this.tablaManager.recalculatePoints();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.setVisible(false);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SettingsDialog.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.tablaWindow);
            this.setTitle(this.getLanguageText("title.settings"));
            this.matchTimeLabel.setText(this.getLanguageText("text.defaultMatchTime"));
            this.hosekomiTimeLabel.setText(this.getLanguageText("text.hosekomiTime"));
            this.newazaHansokumakePenaltiesLabel.setText(this.getLanguageText("text.newazaHansokumakePenalties"));
            this.rulesLabel.setText(this.getLanguageText("text.rules"));
            this.languageLabel.setText(this.getLanguageText("text.language"));
            this.saveButton.setText(this.getLanguageText("text.save"));
            this.cancelButton.setText(this.getLanguageText("text.cancel"));
            long time = this.matchData.getDefaultMatchTime() / 1000L;
            long minutes = time / 60L;
            long seconds = time % 60L;
            String timeText = String.valueOf(minutes) + ":" + this.secondsNumberFormat.format(seconds);
            this.matchTimeField.setText(timeText);
            long hosekomiTime = this.matchData.getMaximumHosekomiTime() / 1000L;
            String hosekomiTimeText = this.secondsNumberFormat.format(hosekomiTime);
            this.hosekomiTimeField.setText(hosekomiTimeText);
            this.newazaHansokumakePenaltiesField.setText(String.valueOf(this.matchData.getNewazaPenaltyHansokumake()));
            this.rulesComboBox.setSelectedItem(this.matchData.getRules());
            this.languagesComboBox.setSelectedItem(this.getLanguageText("locale.current"));
        }
        super.setVisible(b);
    }
}

