/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerProtocol;
import si.nevensrok.common.network.tcp.CustomTlsServer;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.network.tcp.TcpNetworkServer;
import si.nevensrok.common.ssl.BcKeyManager;
import si.nevensrok.common.ssl.BcTrustManager;

public class BcSslTcpNetworkServer
extends TcpNetworkServer {
    private BcKeyManager keyManager;
    private BcTrustManager trustManager;
    private boolean needClientAuth = false;

    public void setKeyManager(BcKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setTrustManager(BcTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.keyManager == null) {
            throw new IllegalArgumentException("Property 'keyManager' is required");
        }
        if (this.needClientAuth && this.trustManager == null) {
            throw new IllegalArgumentException("Property 'trustManager' is required");
        }
        super.afterPropertiesSet();
    }

    @Override
    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        CustomTlsServer tlsServer = new CustomTlsServer();
        tlsServer.setKeyManager(this.keyManager);
        tlsServer.setTrustManager(this.trustManager);
        TlsServerProtocol tlsServerProtocol = new TlsServerProtocol(inputStream, outputStream);
        tlsServerProtocol.accept((TlsServer)tlsServer);
        if (tlsServer.isSslSessionValid()) {
            if (this.needClientAuth && tlsServer.getClientCertificate() == null) {
                throw new IOException("Client certificate was not provided");
            }
            OutputStream socketOutputStream = tlsServerProtocol.getOutputStream();
            InputStream socketInputStream = tlsServerProtocol.getInputStream();
            return new TcpNetworkConnection(socket, socketInputStream, socketOutputStream);
        }
        throw new IOException("Ssl session is invalid");
    }
}

