/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.tools;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.server.web.common.UserData;

public class DateTool
implements ApplicationContextAware {
    private Logger log = LoggerFactory.getLogger(DateTool.class);
    private ApplicationContext applicationContext;
    private UserData userData;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    private DateFormat getDateFormat(Locale locale, String key) {
        String format = this.applicationContext.getMessage(key, null, locale);
        return new SimpleDateFormat(format);
    }

    public String formatDateAndTime(Locale locale, Date date) {
        if (date == null) {
            return "";
        }
        return this.getDateFormat(locale, "dateformat.full").format(date);
    }

    public Date parseDateAndTime(Locale locale, String date) {
        try {
            return this.getDateFormat(locale, "dateformat.full").parse(date);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Error while parsing date", (Throwable)e);
            }
            return null;
        }
    }

    public String formatDate(Locale locale, Date date) {
        if (date == null) {
            return "";
        }
        return this.getDateFormat(locale, "dateformat.date").format(date);
    }

    public Date parseDate(Locale locale, String date) {
        try {
            return this.getDateFormat(locale, "dateformat.date").parse(date);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Error while parsing date", (Throwable)e);
            }
            return null;
        }
    }

    public String formatTime(Locale locale, Date date) {
        if (date == null) {
            return "";
        }
        return this.getDateFormat(locale, "dateformat.time").format(date);
    }

    public Date parseTime(Locale locale, String date) {
        try {
            return this.getDateFormat(locale, "dateformat.time").parse(date);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Error while parsing date", (Throwable)e);
            }
            return null;
        }
    }

    public int parseFightTime(String fightTimeText) {
        String[] parts = fightTimeText.split(":");
        int minutes = 0;
        int seconds = 0;
        if (parts.length > 1) {
            minutes = Integer.parseInt(parts[0]);
            seconds = Integer.parseInt(parts[1]);
        } else {
            seconds = Integer.parseInt(parts[0]);
        }
        return minutes * 60 + seconds;
    }

    public String formatFightTime(int fightTime) {
        int minutes = fightTime / 60;
        int seconds = fightTime % 60;
        return (minutes < 10 ? "0" : "") + String.valueOf(minutes) + ":" + (seconds < 10 ? "0" : "") + String.valueOf(seconds);
    }

    public String formatTimeFromSeconds(int timeInSeconds) {
        int hours = timeInSeconds / 3600;
        int minutes = (timeInSeconds - hours * 3600) / 60;
        int seconds = timeInSeconds - hours * 3600 - minutes * 60;
        return (hours < 10 ? "0" : "") + String.valueOf(hours) + ":" + (minutes < 10 ? "0" : "") + String.valueOf(minutes) + ":" + (seconds < 10 ? "0" : "") + String.valueOf(seconds);
    }
}

