/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.services.impl;

import java.util.Calendar;
import java.util.Set;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchFinishData;
import si.nevensrok.jtekma.common.matches.MatchPartialData;
import si.nevensrok.jtekma.common.matches.NextMatchData;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiHistoryManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.services.TablaService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class TablaServiceImpl
implements TablaService {
    private TatamiManager tatamiManager;
    private MatchManager matchManager;
    private TatamiFightsManager tatamiFightsManager;
    private CategoryManager categoryManager;
    private CompetitionManager competitionManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private TatamiHistoryManager tatamiHistoryManager;

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void setTatamiHistoryManager(TatamiHistoryManager tatamiHistoryManager) {
        this.tatamiHistoryManager = tatamiHistoryManager;
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        return tatami != null;
    }

    public NextMatchData getNextMatch(Credentials credentials) throws ServiceException {
        NewazaCategory newazaCategory;
        AgeCategoryOption ageCategoryOption;
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Match match = this.tatamiFightsManager.getNextMatchForTatami(tatami);
        if (match == null) {
            return null;
        }
        TatamiHistory tatamiHistory = new TatamiHistory();
        tatamiHistory.setTatami(tatami);
        tatamiHistory.setEventDate(Calendar.getInstance().getTime());
        tatamiHistory.setEventType(TatamiHistory.EventType.PULLMATCH);
        tatamiHistory.setMatch(match);
        this.tatamiHistoryManager.createTatamiHistory(tatamiHistory);
        match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
        match.setStartedAt(Calendar.getInstance().getTime());
        this.matchManager.setMatchStartedAt(match);
        Category category = this.categoryManager.getCategoryForMatch(match);
        match.setCategory(category);
        Competition competition = this.competitionManager.getCompetitionForCategory(category);
        NextMatchData nextMatchData = new NextMatchData();
        nextMatchData.setMatch(match);
        nextMatchData.setRules(competition.getRules());
        nextMatchData.setMatchTime(match.getFightTimeLeft());
        nextMatchData.setHosekomiTime(match.getHosekomiTime());
        nextMatchData.setInjuryTime1(match.getInjuryTime1());
        nextMatchData.setInjuryTime2(match.getInjuryTime2());
        if (category instanceof FightingCategory) {
            FightingCategory fightingCategory = (FightingCategory)category;
            ageCategoryOption = this.ageCategoryOptionManager.getForCategory(fightingCategory);
            if (ageCategoryOption != null) {
                if (ageCategoryOption.getFightTime() > 0 && nextMatchData.getMatchTime() == null) {
                    nextMatchData.setMatchTime(ageCategoryOption.getFightTime());
                }
                if (ageCategoryOption.getHosekomiTime() > 0 && nextMatchData.getHosekomiTime() == null) {
                    nextMatchData.setHosekomiTime(ageCategoryOption.getHosekomiTime());
                }
            }
        } else if (category instanceof NewazaCategory && (ageCategoryOption = this.ageCategoryOptionManager.getForCategory(newazaCategory = (NewazaCategory)category)) != null) {
            if (ageCategoryOption.getFightTime() > 0 && nextMatchData.getMatchTime() == null) {
                nextMatchData.setMatchTime(ageCategoryOption.getFightTime());
            }
            if (ageCategoryOption.getHosekomiTime() > 0 && nextMatchData.getHosekomiTime() == null) {
                nextMatchData.setHosekomiTime(ageCategoryOption.getHosekomiTime());
            }
            nextMatchData.setNewazaPenaltyHansokumake(ageCategoryOption.getNewazaPenaltyHansokumake());
        }
        if (nextMatchData.getMatchTime() == null) {
            nextMatchData.setMatchTime(Integer.valueOf(180));
        }
        if (nextMatchData.getHosekomiTime() == null) {
            nextMatchData.setHosekomiTime(Integer.valueOf(15));
        }
        Set matchPoints = this.matchManager.getMatchPointsForMatch(match);
        nextMatchData.setMatchPoints(matchPoints);
        boolean challenge1 = this.matchManager.isChallengeAvailable(category, match, match.getCompetitor1());
        boolean challenge2 = this.matchManager.isChallengeAvailable(category, match, match.getCompetitor2());
        nextMatchData.setChallengeAvailable1(Boolean.valueOf(challenge1));
        nextMatchData.setChallengeAvailable2(Boolean.valueOf(challenge2));
        nextMatchData.setChallengesWon1(match.getChallengesWon1());
        nextMatchData.setChallengesWon2(match.getChallengesWon2());
        nextMatchData.setChallengesLost1(match.getChallengesLost1());
        nextMatchData.setChallengesLost2(match.getChallengesLost2());
        return nextMatchData;
    }

    public void setPartialData(Credentials credentials, MatchPartialData matchPartialData) {
        Match match = matchPartialData.getMatch();
        Long matchId = match.getMatchId();
        if ((match = this.matchManager.getById(matchId)) == null) {
            throw new ServiceException("Match with id [" + matchId + "] not found");
        }
        if (match.getStatus() == Match.Status.FINISHED) {
            return;
        }
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Tatami matchTatami = this.tatamiManager.getTatamiForMatch(match);
        if (matchTatami == null) {
            throw new ServiceException("Match is not on tatami");
        }
        if (!matchTatami.getTatamiId().equals(tatami.getTatamiId())) {
            throw new ServiceException("Match is not on tatami");
        }
        match.setFightTimeLeft(matchPartialData.getFightTimeLeft());
        match.setInjuryTime1(matchPartialData.getInjuryTime1());
        match.setInjuryTime2(matchPartialData.getInjuryTime2());
        match.setChallengesWon1(matchPartialData.getChallengesWon1());
        match.setChallengesWon2(matchPartialData.getChallengesWon2());
        match.setChallengesLost1(matchPartialData.getChallengesLost1());
        match.setChallengesLost2(matchPartialData.getChallengesLost2());
        if (match.getStatus() == Match.Status.INPROGRESS || this.tatamiFightsManager.isNextMatchForTatami(matchTatami, match)) {
            this.matchManager.setMatchPointsForMatch(match, matchPartialData.getMatchPoints());
            this.matchManager.setFightTimeLeft(match);
            this.matchManager.setInjuryTime(match);
            this.matchManager.setChallenges(match);
        }
    }

    public void finishMatch(Credentials credentials, MatchFinishData matchFinishData) throws ServiceException {
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Match match = matchFinishData.getMatch();
        Long matchId = match.getMatchId();
        if ((match = this.matchManager.getById(matchId)) == null) {
            throw new ServiceException("Match with id [" + matchId + "] not found");
        }
        if (match.getStatus() == Match.Status.FINISHED) {
            return;
        }
        Tatami matchTatami = this.tatamiManager.getTatamiForMatch(match);
        if (matchTatami == null) {
            throw new ServiceException("Match is not on tatami");
        }
        if (!matchTatami.getTatamiId().equals(tatami.getTatamiId())) {
            throw new ServiceException("Match is not on tatami");
        }
        TatamiHistory tatamiHistory = new TatamiHistory();
        tatamiHistory.setTatami(tatami);
        tatamiHistory.setEventDate(Calendar.getInstance().getTime());
        tatamiHistory.setEventType(TatamiHistory.EventType.PUSHMATCH);
        tatamiHistory.setMatch(match);
        this.tatamiHistoryManager.createTatamiHistory(tatamiHistory);
        match.setFightTimeLeft(matchFinishData.getFightTimeLeft());
        match.setInjuryTime1(matchFinishData.getInjuryTime1());
        match.setInjuryTime2(matchFinishData.getInjuryTime2());
        match.setChallengesWon1(matchFinishData.getChallengesWon1());
        match.setChallengesWon2(matchFinishData.getChallengesWon2());
        match.setChallengesLost1(matchFinishData.getChallengesLost1());
        match.setChallengesLost2(matchFinishData.getChallengesLost2());
        if (match.getStatus() == Match.Status.INPROGRESS || this.tatamiFightsManager.isNextMatchForTatami(matchTatami, match)) {
            this.matchManager.setMatchPointsForMatch(match, matchFinishData.getMatchPoints());
            this.matchManager.setMatchPointDetailsForMatch(match, matchFinishData.getPointDetails());
            this.matchManager.setFightTimeLeft(match);
            this.matchManager.setInjuryTime(match);
            this.matchManager.setChallenges(match);
            this.matchManager.setMatchStatus(match, Match.Status.FINISHED);
            match.setFinishedAt(Calendar.getInstance().getTime());
            this.matchManager.setMatchFinishedAt(match);
        }
    }
}

