/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers;

import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.Role;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/select-competition"})
@SessionAttributes(value={"selectCompetitionFilter"})
public class SelectCompetitionController
extends CoreController {
    @ModelAttribute(value="selectCompetitionFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @RequestMapping
    public String selectCompetition(HttpServletRequest request, Model model, @ModelAttribute(value="selectCompetitionFilter") SearchFilter searchFilter) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        GroupFilter statusFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)statusFilter);
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competition.Status.ACTIVE));
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competition.Status.FINISHED));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("competitonDate", Sort.Field.Direction.ASC));
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        Integer page = searchFilter.getPage();
        Integer showPerPage = searchFilter.getShowPerPage();
        dataFilter.setStartIndex(Integer.valueOf((page - 1) * showPerPage));
        dataFilter.setItemLimit(Integer.valueOf(showPerPage));
        Long totalPages = 1L;
        if (this.getUserData().getLoginedUser().getIsSuperAdmin().booleanValue()) {
            PageDataResult resultPage = this.getManagersList().getCompetitionManager().find((DataFilter)dataFilter);
            model.addAttribute("competitions", (Object)resultPage.getData());
            totalPages = (long)Math.ceil((double)resultPage.getTotalCount().longValue() / showPerPage.doubleValue());
        } else {
            PageDataResult resultPage = this.getManagersList().getCompetitionManager().findForUser(this.getUserData().getLoginedUser(), (DataFilter)dataFilter);
            model.addAttribute("competitions", (Object)resultPage.getData());
            totalPages = (long)Math.ceil((double)resultPage.getTotalCount().longValue() / showPerPage.doubleValue());
        }
        if (totalPages < 1L) {
            totalPages = 1L;
        }
        model.addAttribute("totalPages", (Object)totalPages);
        return "select-competition";
    }

    @RequestMapping(value={"/{competitionId}"})
    public String selectCompetition(HttpServletRequest request, Model model, @ModelAttribute(value="selectCompetitionFilter") SearchFilter searchFilter, @PathVariable(value="competitionId") Long competitionId) {
        Competition competition = this.getManagersList().getCompetitionManager().getById(competitionId);
        if (this.getUserData().getLoginedUser().getIsSuperAdmin().booleanValue()) {
            this.getUserData().setCompetition(competition);
        } else {
            Role role = this.getManagersList().getCompetitionManager().getCompetitionRoleForUser(this.getUserData().getLoginedUser(), competition);
            if (role == null) {
                return "select-competition";
            }
            this.getUserData().setCompetition(competition);
        }
        return "redirect:/";
    }
}

