/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.documents.pdf;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.common.documents.DocumentException;
import si.nevensrok.common.documents.common.Alignment;
import si.nevensrok.common.documents.common.Border;
import si.nevensrok.common.documents.common.BorderMargin;
import si.nevensrok.common.documents.common.Content;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.documents.common.FontType;
import si.nevensrok.common.documents.common.Image;
import si.nevensrok.common.documents.common.LineList;
import si.nevensrok.common.documents.common.PageBreak;
import si.nevensrok.common.documents.common.PageDirection;
import si.nevensrok.common.documents.common.PageSize;
import si.nevensrok.common.documents.common.Paragraph;
import si.nevensrok.common.documents.common.Table;
import si.nevensrok.common.documents.common.TableCell;
import si.nevensrok.common.documents.common.TableRow;
import si.nevensrok.common.documents.common.TextContent;
import si.nevensrok.common.documents.common.VerticalAlignment;
import si.nevensrok.common.documents.pdf.LineInfo;
import si.nevensrok.common.documents.pdf.TableCellInfo;
import si.nevensrok.common.documents.pdf.TableRowInfo;

public class PdfDocumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(PdfDocumentBuilder.class);
    private static final String FONTDIR = "/si/nevensrok/common/documents/fonts";
    private Document document;
    private OutputStream outputStream;
    private float imageQuality;
    private int imageDpi;
    private PDDocument pdDocument;
    private PDPage page;
    private PDRectangle pageSize;
    private PDType0Font font;
    private PDPageContentStream pageContentStream;
    private float fontSize = 12.0f;
    private Color fontColor = Color.BLACK;
    private float documentPosition = 0.0f;
    private boolean isContentOnPage = false;
    private Map<String, PDType0Font> customFonts = new HashMap<String, PDType0Font>();
    private BorderMargin pageBorder;

    public PdfDocumentBuilder(Document document, OutputStream outputStream, float imageQuality, int imageDpi) {
        this.document = document;
        this.outputStream = outputStream;
        this.imageQuality = imageQuality;
        this.imageDpi = imageDpi;
    }

    public void build() throws DocumentException {
        log.trace("Building pdf document");
        try {
            this.pdDocument = new PDDocument();
            this.createPage(this.document.getPageSize(), this.document.getPageDirection(), this.document.getDocumentBorder());
            for (Content content : this.document.getContentList()) {
                this.pageContentStream.close();
                this.pageContentStream = new PDPageContentStream(this.pdDocument, this.page, PDPageContentStream.AppendMode.APPEND, true);
                if (content instanceof PageBreak) {
                    PageBreak pageBreakContent = (PageBreak)content;
                    this.createPage(pageBreakContent.getPageSize(), pageBreakContent.getPageDirection(), pageBreakContent.getPageBorder());
                    continue;
                }
                if (content instanceof Paragraph) {
                    this.addParagraph((Paragraph)content);
                    continue;
                }
                if (content instanceof LineList) {
                    this.addLineList((LineList)content);
                    continue;
                }
                if (content instanceof Table) {
                    this.addTable((Table)content);
                    continue;
                }
                if (content instanceof Image) {
                    this.addImage((Image)content);
                    continue;
                }
                log.error("Unsupported content type {}", (Object)content.getClass().getName());
            }
            this.pageContentStream.close();
            log.trace("Saving document");
            this.pdDocument.save(this.outputStream);
            this.pdDocument.close();
        }
        catch (DocumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentException("Error creating pdf document", e);
        }
        finally {
            try {
                this.pdDocument.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createPage() throws IOException {
        this.createPage(null, null, null);
    }

    private void createPage(PageSize pageSize, PageDirection pageDirection, BorderMargin pageBorder) throws IOException {
        log.trace("Creating page");
        if (pageSize != null) {
            switch (pageSize) {
                case A0: {
                    this.pageSize = PDRectangle.A0;
                    break;
                }
                case A1: {
                    this.pageSize = PDRectangle.A1;
                    break;
                }
                case A2: {
                    this.pageSize = PDRectangle.A2;
                    break;
                }
                case A3: {
                    this.pageSize = PDRectangle.A3;
                    break;
                }
                case A4: {
                    this.pageSize = PDRectangle.A4;
                    break;
                }
                case A5: {
                    this.pageSize = PDRectangle.A5;
                    break;
                }
                case A6: {
                    this.pageSize = PDRectangle.A6;
                }
            }
            if (pageDirection == PageDirection.LANDSCAPE) {
                this.pageSize = new PDRectangle(this.pageSize.getHeight(), this.pageSize.getWidth());
            }
        }
        if (pageBorder != null) {
            this.pageBorder = pageBorder;
        }
        this.page = new PDPage(this.pageSize);
        this.pdDocument.addPage(this.page);
        log.trace("Page size: {}x{}", (Object)Float.valueOf(this.pageSize.getWidth()), (Object)Float.valueOf(this.pageSize.getHeight()));
        this.isContentOnPage = false;
        float topMargin = 0.0f;
        if (this.pageBorder != null) {
            topMargin = this.pageBorder.getTop() / 100.0f * this.pageSize.getHeight();
        }
        this.documentPosition = this.pageSize.getHeight() - topMargin;
        if (this.pageContentStream != null) {
            this.pageContentStream.close();
        }
        this.pageContentStream = new PDPageContentStream(this.pdDocument, this.page, PDPageContentStream.AppendMode.APPEND, true);
    }

    private void addParagraph(Paragraph paragraph) throws IOException {
        log.trace("Adding paragraph content");
        String text = paragraph.getText();
        log.trace("Text to add: [{}]", (Object)text);
        if (text == null || text.isEmpty()) {
            return;
        }
        float leftBorder = this.pageBorder.getLeft() / 100.0f * this.pageSize.getWidth() + paragraph.getMargin().getLeft() / 100.0f * this.pageSize.getWidth();
        float rightBorder = this.pageBorder.getRight() / 100.0f * this.pageSize.getWidth() + paragraph.getMargin().getRight() / 100.0f * this.pageSize.getWidth();
        float topBorder = paragraph.getMargin().getTop() / 100.0f * this.pageSize.getWidth();
        float bottomBorder = paragraph.getMargin().getBottom() / 100.0f * this.pageSize.getWidth();
        float drawWidth = this.pageSize.getWidth() - leftBorder - rightBorder;
        if (this.isContentOnPage) {
            this.documentPosition -= topBorder;
        }
        this.isContentOnPage = true;
        List<LineInfo> lineInfos = this.getLineInfos(text, paragraph.getAlignment(), paragraph.getFontType(), paragraph.getFontSize(), paragraph.getColor(), paragraph.getBold(), paragraph.getItalic(), drawWidth);
        this.setTextContentFont(paragraph);
        for (LineInfo lineInfo : lineInfos) {
            this.documentPosition -= lineInfo.getHeight();
            if (this.checkEndPage()) {
                this.documentPosition -= lineInfo.getHeight();
            }
            this.writeLineText(lineInfo.getText(), lineInfo.getAlignment(), leftBorder, this.documentPosition, drawWidth);
        }
        if (this.isContentOnPage) {
            this.documentPosition -= bottomBorder;
        }
    }

    private void writeLineText(String text, Alignment alignment, float x, float y, float width) throws IOException {
        float textWidth = this.font.getStringWidth(text) / 1000.0f * this.fontSize;
        if (alignment == Alignment.RIGHT) {
            float left = x + width - textWidth;
            this.pageContentStream.beginText();
            this.pageContentStream.newLineAtOffset(left, y);
            this.pageContentStream.showText(text);
            this.pageContentStream.endText();
        } else if (alignment == Alignment.CENTER) {
            float left = x + (width - textWidth) / 2.0f;
            this.pageContentStream.beginText();
            this.pageContentStream.newLineAtOffset(left, y);
            this.pageContentStream.showText(text);
            this.pageContentStream.endText();
        } else if (alignment == Alignment.JUSTIFY) {
            float left = x;
            int spacesCount = this.countSpaces(text);
            if (spacesCount > 0) {
                String[] words;
                float addedSpaceDiff = (width - textWidth) / (float)spacesCount;
                for (String word : words = text.split("\\x20")) {
                    float wordWidth = this.font.getStringWidth(word + " ") / 1000.0f * this.fontSize;
                    this.pageContentStream.beginText();
                    this.pageContentStream.newLineAtOffset(left, y);
                    this.pageContentStream.showText(word);
                    this.pageContentStream.endText();
                    left += wordWidth + addedSpaceDiff;
                }
            } else {
                this.pageContentStream.beginText();
                this.pageContentStream.newLineAtOffset(left, y);
                this.pageContentStream.showText(text);
                this.pageContentStream.endText();
            }
        } else {
            float left = x;
            this.pageContentStream.beginText();
            this.pageContentStream.newLineAtOffset(left, y);
            this.pageContentStream.showText(text);
            this.pageContentStream.endText();
        }
    }

    private void setTextContentFont(TextContent textContent) throws IOException {
        this.font = this.generateFont(textContent.getFontType(), textContent.getBold(), textContent.getItalic());
        this.fontSize = textContent.getFontSize().floatValue();
        this.fontColor = textContent.getColor();
        this.pageContentStream.setFont((PDFont)this.font, this.fontSize);
        this.pageContentStream.setNonStrokingColor(this.fontColor);
    }

    private void setLineInfoFont(LineInfo lineInfo) throws IOException {
        this.font = this.generateFont(lineInfo.getFontType(), lineInfo.getBold(), lineInfo.getItalic());
        this.fontSize = lineInfo.getFontSize().floatValue();
        this.fontColor = lineInfo.getColor();
        this.pageContentStream.setFont((PDFont)this.font, this.fontSize);
        this.pageContentStream.setNonStrokingColor(this.fontColor);
    }

    private PDType0Font generateFont(FontType fontType, Boolean bold, Boolean italic) throws IOException {
        PDType0Font font = null;
        if (bold.booleanValue() && italic.booleanValue()) {
            switch (fontType) {
                case DejaVuSans: {
                    font = this.loadCustomFont("DejaVuSans-BoldOblique.ttf");
                }
            }
        } else if (bold.booleanValue()) {
            switch (fontType) {
                case DejaVuSans: {
                    font = this.loadCustomFont("DejaVuSans-Bold.ttf");
                }
            }
        } else if (italic.booleanValue()) {
            switch (fontType) {
                case DejaVuSans: {
                    font = this.loadCustomFont("DejaVuSans-Oblique.ttf");
                }
            }
        } else {
            switch (fontType) {
                case DejaVuSans: {
                    font = this.loadCustomFont("DejaVuSans.ttf");
                }
            }
        }
        return font;
    }

    private int countSpaces(String text) {
        int spacesCount = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != ' ') continue;
            ++spacesCount;
        }
        return spacesCount;
    }

    private static float getFontHeight(PDType0Font font, float fontSize) {
        return font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * fontSize;
    }

    private static float getFontWidth(PDType0Font font, float fontSize, String text) throws IOException {
        return font.getStringWidth(text) / 1000.0f * fontSize;
    }

    private boolean checkEndPage() throws IOException {
        float bottomMargin = this.pageBorder.getBottom() / 100.0f * this.pageSize.getHeight();
        if (this.documentPosition < bottomMargin) {
            this.createPage();
            this.isContentOnPage = true;
            this.pageContentStream.setFont((PDFont)this.font, this.fontSize);
            this.pageContentStream.setNonStrokingColor(this.fontColor);
            return true;
        }
        return false;
    }

    private List<LineInfo> getLineInfos(String text, Alignment alignment, FontType fontType, Float fontSize, Color color, Boolean bold, Boolean italic, float drawWidth) throws IOException {
        PDType0Font font = this.generateFont(fontType, bold, italic);
        LinkedList<LineInfo> lineInfos = new LinkedList<LineInfo>();
        if (text.isEmpty()) {
            return lineInfos;
        }
        StringBuilder line = new StringBuilder();
        String[] words = text.split("\\x20");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (line.length() > 0) {
                line.append(" ");
            }
            line.append(word);
            float textWidth = PdfDocumentBuilder.getFontWidth(font, fontSize.floatValue(), line.toString());
            if (!(textWidth > drawWidth)) continue;
            if (line.length() == word.length()) {
                while (textWidth > drawWidth && line.length() > 2) {
                    line.deleteCharAt(line.length() - 1);
                    textWidth = font.getStringWidth(line.toString()) / 1000.0f * fontSize.floatValue();
                }
                word = word.substring(line.length());
            } else {
                line.delete(line.length() - word.length() - 1, line.length());
            }
            textWidth = PdfDocumentBuilder.getFontWidth(font, fontSize.floatValue(), line.toString());
            float lineHeight = PdfDocumentBuilder.getFontHeight(font, fontSize.floatValue());
            lineInfos.add(new LineInfo(line.toString(), alignment, fontType, fontSize, color, bold, italic, textWidth, lineHeight));
            line = new StringBuilder();
            line.append(word);
        }
        float textWidth = PdfDocumentBuilder.getFontWidth(font, fontSize.floatValue(), line.toString());
        float lineHeight = PdfDocumentBuilder.getFontHeight(font, fontSize.floatValue());
        if (alignment == Alignment.JUSTIFY) {
            alignment = Alignment.LEFT;
        }
        lineInfos.add(new LineInfo(line.toString(), alignment, fontType, fontSize, color, bold, italic, textWidth, lineHeight));
        return lineInfos;
    }

    private void addLineList(LineList lineList) throws IOException {
        log.trace("Adding line list content");
        this.setTextContentFont(lineList);
        float leftBorder = this.pageBorder.getLeft() / 100.0f * this.pageSize.getWidth() + lineList.getMargin().getLeft() / 100.0f * this.pageSize.getWidth();
        float rightBorder = this.pageBorder.getRight() / 100.0f * this.pageSize.getWidth() + lineList.getMargin().getRight() / 100.0f * this.pageSize.getWidth();
        float topBorder = lineList.getMargin().getTop() / 100.0f * this.pageSize.getWidth();
        float bottomBorder = lineList.getMargin().getBottom() / 100.0f * this.pageSize.getWidth();
        float drawWidth = this.pageSize.getWidth() - leftBorder - rightBorder;
        if (this.isContentOnPage) {
            this.documentPosition -= topBorder;
        }
        float lineHeight = PdfDocumentBuilder.getFontHeight(this.font, this.fontSize);
        String icon = "\u2022";
        float iconX = leftBorder + 10.0f;
        float iconWidth = 15.0f;
        float textX = leftBorder + 30.0f;
        float textWidth = drawWidth - 30.0f;
        int n = 1;
        for (String line : lineList.getLines()) {
            List<LineInfo> lineInfos = this.getLineInfos(line, lineList.getAlignment(), lineList.getFontType(), lineList.getFontSize(), lineList.getColor(), lineList.getBold(), lineList.getItalic(), textWidth);
            this.documentPosition -= lineHeight;
            if (this.checkEndPage()) {
                this.documentPosition -= lineHeight;
            }
            if (lineList.getIconType() == LineList.IconType.NUMERIC) {
                this.writeLineText(String.valueOf(n) + ".", Alignment.RIGHT, iconX, this.documentPosition, iconWidth);
            } else if (lineList.getIconType() == LineList.IconType.LOWER_LETTERS) {
                this.writeLineText(this.getListChar(n) + ")", Alignment.RIGHT, iconX, this.documentPosition, iconWidth);
            } else if (lineList.getIconType() == LineList.IconType.UPPER_LETTERS) {
                this.writeLineText(this.getListChar(n).toUpperCase() + ")", Alignment.RIGHT, iconX, this.documentPosition, iconWidth);
            } else {
                this.writeLineText(icon, Alignment.RIGHT, iconX, this.documentPosition, iconWidth);
            }
            this.documentPosition += lineHeight;
            for (LineInfo lineInfo : lineInfos) {
                this.documentPosition -= lineInfo.getHeight();
                if (this.checkEndPage()) {
                    this.documentPosition -= lineInfo.getHeight();
                }
                this.writeLineText(lineInfo.getText(), lineInfo.getAlignment(), textX, this.documentPosition, textWidth);
            }
            ++n;
        }
        if (this.isContentOnPage) {
            this.documentPosition -= bottomBorder;
        }
    }

    private void addTable(Table table) throws IOException {
        log.trace("Adding table content");
        this.setTextContentFont(table);
        float leftBorder = this.pageBorder.getLeft() / 100.0f * this.pageSize.getWidth() + table.getMargin().getLeft() / 100.0f * this.pageSize.getWidth();
        float rightBorder = this.pageBorder.getRight() / 100.0f * this.pageSize.getWidth() + table.getMargin().getRight() / 100.0f * this.pageSize.getWidth();
        float topBorder = table.getMargin().getTop() / 100.0f * this.pageSize.getWidth();
        float bottomBorder = table.getMargin().getBottom() / 100.0f * this.pageSize.getWidth();
        float drawWidth = this.pageSize.getWidth() - leftBorder - rightBorder;
        float tableLeftPos = leftBorder;
        float tableWidth = drawWidth / 100.0f * table.getWidthPrecentage();
        if (table.getAlignment() == Alignment.CENTER) {
            tableLeftPos = leftBorder + (drawWidth - tableWidth) / 2.0f;
        } else if (table.getAlignment() == Alignment.RIGHT) {
            tableLeftPos = leftBorder + drawWidth - tableWidth;
        }
        if (this.isContentOnPage) {
            this.documentPosition -= topBorder;
        }
        List<TableRowInfo> tableRowInfos = this.getTableRowInfos(table, tableWidth);
        for (TableRowInfo tableRowInfo : tableRowInfos) {
            this.documentPosition -= tableRowInfo.getHeight();
            if (this.checkEndPage()) {
                this.documentPosition -= tableRowInfo.getHeight();
            }
            float cellLeft = tableLeftPos;
            float cellTop = this.documentPosition + tableRowInfo.getHeight();
            for (TableCellInfo tableCellInfo : tableRowInfo.getTableCellInfos()) {
                if (tableCellInfo.getBackgroundColor() != null) {
                    this.fillBackgroundColor(cellLeft, cellTop, tableCellInfo.getWidth(), tableRowInfo.getHeight(), tableCellInfo.getBackgroundColor());
                }
                this.drawBorder(cellLeft, cellTop, cellLeft, cellTop - tableRowInfo.getHeight(), tableCellInfo.getCellBorder().getLeft());
                this.drawBorder(cellLeft, cellTop, cellLeft + tableCellInfo.getWidth(), cellTop, tableCellInfo.getCellBorder().getTop());
                this.drawBorder(cellLeft + tableCellInfo.getWidth(), cellTop, cellLeft + tableCellInfo.getWidth(), cellTop - tableRowInfo.getHeight(), tableCellInfo.getCellBorder().getRight());
                this.drawBorder(cellLeft, cellTop - tableRowInfo.getHeight(), cellLeft + tableCellInfo.getWidth(), cellTop - tableRowInfo.getHeight(), tableCellInfo.getCellBorder().getBottom());
                float textTop = cellTop;
                if (tableCellInfo.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                    textTop = this.documentPosition;
                    for (LineInfo lineInfo : tableCellInfo.getLineInfos()) {
                        textTop += lineInfo.getHeight();
                    }
                } else if (tableCellInfo.getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                    textTop = cellTop + (this.documentPosition - cellTop) / 2.0f;
                    for (LineInfo lineInfo : tableCellInfo.getLineInfos()) {
                        textTop += lineInfo.getHeight() / 2.0f;
                    }
                }
                for (LineInfo lineInfo : tableCellInfo.getLineInfos()) {
                    this.setLineInfoFont(lineInfo);
                    this.writeLineText(lineInfo.getText(), lineInfo.getAlignment(), cellLeft + 2.0f, (textTop -= lineInfo.getHeight()) + 4.0f, tableCellInfo.getWidth() - 4.0f);
                }
                cellLeft += tableCellInfo.getWidth();
            }
        }
        if (this.isContentOnPage) {
            this.documentPosition -= bottomBorder;
        }
    }

    private List<TableRowInfo> getTableRowInfos(Table table, float drawWidth) throws IOException {
        LinkedList<TableRowInfo> tableRowInfos = new LinkedList<TableRowInfo>();
        for (TableRow tableRow : table.getTableRows()) {
            TableRowInfo tableRowInfo = new TableRowInfo();
            tableRowInfos.add(tableRowInfo);
            float rowWidth = 0.0f;
            float rowHeight = 0.0f;
            float cellSumWidth = 0.0f;
            for (TableCell tableCell : tableRow.getTableCells()) {
                cellSumWidth += tableCell.getWidth();
            }
            float cellWidthRatio = drawWidth / cellSumWidth;
            for (TableCell tableCell : tableRow.getTableCells()) {
                TableCellInfo tableCellInfo = new TableCellInfo();
                tableRowInfo.getTableCellInfos().add(tableCellInfo);
                tableCellInfo.setCellBorder(tableCell.getCellBorder());
                tableCellInfo.setVerticalAlignment(tableCell.getVerticalAlignment());
                tableCellInfo.setBackgroundColor(tableCell.getBackgroundColor());
                float cellWidth = cellWidthRatio * tableCell.getWidth();
                tableCellInfo.setWidth(cellWidth);
                float cellHeight = 0.0f;
                for (Paragraph paragraph : tableCell.getContentList()) {
                    List<LineInfo> lineInfos = this.getLineInfos(paragraph.getText(), paragraph.getAlignment(), paragraph.getFontType(), paragraph.getFontSize(), paragraph.getColor(), paragraph.getBold(), paragraph.getItalic(), cellWidth - 4.0f);
                    for (LineInfo lineInfo : lineInfos) {
                        tableCellInfo.getLineInfos().add(lineInfo);
                        cellHeight += lineInfo.getHeight();
                    }
                }
                tableCellInfo.setHeight(cellHeight);
                rowWidth += cellWidth;
                rowHeight = Math.max(rowHeight, cellHeight);
            }
            tableRowInfo.setWidth(rowWidth);
            tableRowInfo.setHeight(rowHeight);
        }
        return tableRowInfos;
    }

    private void drawBorder(float x1, float y1, float x2, float y2, Border border) throws IOException {
        if (border.getBorderType() != Border.BorderType.NONE) {
            this.pageContentStream.setStrokingColor(border.getBorderColor());
            this.pageContentStream.setLineWidth(border.getBorderSize());
            this.pageContentStream.moveTo(x1, y1);
            this.pageContentStream.lineTo(x2, y2);
            this.pageContentStream.stroke();
            this.pageContentStream.closeAndStroke();
            this.pageContentStream.setNonStrokingColor(this.fontColor);
        }
    }

    private void fillBackgroundColor(float x1, float y1, float width, float height, Color color) throws IOException {
    }

    private PDType0Font loadCustomFont(String fontFile) throws IOException {
        PDType0Font font = this.customFonts.get(fontFile);
        if (font == null) {
            font = PDType0Font.load((PDDocument)this.pdDocument, (InputStream)new ClassPathResource("/si/nevensrok/common/documents/fonts/" + fontFile).getInputStream());
            this.customFonts.put(fontFile, font);
        }
        return font;
    }

    private void addImage(Image image) throws IOException {
        log.trace("Adding image content");
        if (image.getImageData() != null) {
            float leftBorder = this.pageBorder.getLeft() / 100.0f * this.pageSize.getWidth() + image.getMargin().getLeft() / 100.0f * this.pageSize.getWidth();
            float rightBorder = this.pageBorder.getRight() / 100.0f * this.pageSize.getWidth() + image.getMargin().getRight() / 100.0f * this.pageSize.getWidth();
            float topBorder = image.getMargin().getTop() / 100.0f * this.pageSize.getWidth();
            float bottomBorder = image.getMargin().getBottom() / 100.0f * this.pageSize.getWidth();
            float drawWidth = this.pageSize.getWidth() - leftBorder - rightBorder;
            if (this.isContentOnPage) {
                this.documentPosition -= topBorder;
            }
            PDImageXObject imageObject = JPEGFactory.createFromImage((PDDocument)this.pdDocument, (BufferedImage)image.getImageData(), (float)this.imageQuality, (int)this.imageDpi);
            float width = imageObject.getWidth();
            float height = imageObject.getHeight();
            if ((float)imageObject.getWidth() > drawWidth) {
                width = drawWidth;
                height = (float)imageObject.getHeight() * width / (float)imageObject.getWidth();
            }
            float left = leftBorder;
            if (image.getAlignment() == Alignment.RIGHT) {
                left = left + drawWidth - width;
            } else if (image.getAlignment() == Alignment.CENTER) {
                left += (drawWidth - width) / 2.0f;
            }
            this.documentPosition -= height;
            if (this.checkEndPage()) {
                this.documentPosition -= height;
            }
            this.pageContentStream.drawImage(imageObject, left, this.documentPosition, width, height);
            if (this.isContentOnPage) {
                this.documentPosition -= bottomBorder;
            }
        }
    }

    public String getListChar(int n) {
        StringBuilder text = new StringBuilder();
        while (n > 0) {
            char c = (char)(97 + n % 26 - 1);
            text.append(c);
            n /= 26;
        }
        return text.toString();
    }
}

