/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.jtekma.common.system.RecoverPasswordToken;
import si.nevensrok.jtekma.server.dl.dao.RecoverPasswordTokenDAO;
import si.nevensrok.jtekma.server.management.RecoverPasswordTokenManager;

public class RecoverPasswordTokenManagerImpl
implements RecoverPasswordTokenManager {
    private static final Logger log = LoggerFactory.getLogger(RecoverPasswordTokenManagerImpl.class);
    private RecoverPasswordTokenDAO recoverPasswordTokenDAO;
    private int tokenExpireTime = 172800000;

    public void setRecoverPasswordTokenDAO(RecoverPasswordTokenDAO recoverPasswordTokenDAO) {
        this.recoverPasswordTokenDAO = recoverPasswordTokenDAO;
    }

    public void setTokenExpireTime(int tokenExpireTime) {
        this.tokenExpireTime = tokenExpireTime;
    }

    @Transactional(value="jtekmaTransactionManager")
    public RecoverPasswordToken createRecoverPasswordToken(RecoverPasswordToken recoverPasswordToken) {
        if (log.isDebugEnabled()) {
            log.debug("Creating recover password token {}", (Object)recoverPasswordToken);
        }
        return (RecoverPasswordToken)this.recoverPasswordTokenDAO.create((Pojo)recoverPasswordToken);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteRecoverPasswordToken(RecoverPasswordToken recoverPasswordToken) {
        if (log.isDebugEnabled()) {
            log.debug("Deleting recover password token {}", (Object)recoverPasswordToken);
        }
        this.recoverPasswordTokenDAO.delete((Pojo)recoverPasswordToken);
    }

    @Transactional(value="jtekmaTransactionManager")
    public RecoverPasswordToken getPasswordToken(String id) {
        RecoverPasswordToken recoverPasswordToken = (RecoverPasswordToken)this.recoverPasswordTokenDAO.getById((Object)id);
        if (System.currentTimeMillis() < recoverPasswordToken.getCreatedDate().getTime() + (long)this.tokenExpireTime) {
            return recoverPasswordToken;
        }
        return null;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void removeExpired() {
        Calendar expirityDate = Calendar.getInstance();
        expirityDate.add(13, -this.tokenExpireTime);
        this.recoverPasswordTokenDAO.removeOlderThan(expirityDate.getTime());
    }
}

