/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.CertificateRepository;
import si.nevensrok.common.ssl.RevokedCertificateChecker;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.utils.HashUtil;
import si.nevensrok.common.x509cert.CertificateUtil;

public class CertificateChainVerifier {
    private static final Logger log = LoggerFactory.getLogger(CertificateChainVerifier.class);
    private boolean checkDate = true;
    private boolean checkSigningFlag = true;
    private boolean noCaCheck = false;
    private Date[] dates = new Date[]{Calendar.getInstance().getTime()};
    private X509Certificate[] certificateChain;
    private RevokedCertificateChecker revokedCertificateChecker = null;
    private List<X509Certificate> certificateAuthorities = new LinkedList<X509Certificate>();
    private CertificateRepository certificateRepository;
    private Map<String, X509Certificate> certificateAuthorityCache = null;

    public CertificateChainVerifier withCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
        return this;
    }

    public CertificateChainVerifier withCheckSigningFlag(boolean checkSigningFlag) {
        this.checkSigningFlag = checkSigningFlag;
        return this;
    }

    public CertificateChainVerifier withNoCaCheck(boolean noCaCheck) {
        this.noCaCheck = noCaCheck;
        return this;
    }

    public CertificateChainVerifier withDates(Date[] dates) {
        this.dates = dates;
        return this;
    }

    public CertificateChainVerifier withDates(List<Date> dates) {
        this.dates = dates.toArray(new Date[dates.size()]);
        return this;
    }

    public CertificateChainVerifier withDate(Date date) {
        this.dates = new Date[]{date};
        return this;
    }

    public CertificateChainVerifier withCalendars(Calendar[] dates) {
        this.dates = new Date[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            this.dates[i] = dates[i].getTime();
        }
        return this;
    }

    public CertificateChainVerifier withCalendars(List<Calendar> dates) {
        return this.withCalendars(dates.toArray(new Calendar[dates.size()]));
    }

    public CertificateChainVerifier withCalendar(Calendar date) {
        this.dates = new Date[]{date.getTime()};
        return this;
    }

    public CertificateChainVerifier withCertificateChain(X509Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public CertificateChainVerifier withCertificateChain(List<X509Certificate> certificateChain) {
        this.certificateChain = certificateChain.toArray(new X509Certificate[certificateChain.size()]);
        return this;
    }

    public CertificateChainVerifier withCertificate(X509Certificate certificate) {
        this.certificateChain = new X509Certificate[]{certificate};
        return this;
    }

    public CertificateChainVerifier withRevokedCertificateChecker(RevokedCertificateChecker revokedCertificateChecker) {
        this.revokedCertificateChecker = revokedCertificateChecker;
        return this;
    }

    public CertificateChainVerifier withCertificateAuthorities(Collection<X509Certificate> certificateAuthorities) {
        if (certificateAuthorities != null) {
            this.certificateAuthorities.addAll(certificateAuthorities);
        }
        return this;
    }

    public CertificateChainVerifier withCertificateAuthority(X509Certificate ... certificateAuthority) {
        for (X509Certificate cert : certificateAuthority) {
            this.certificateAuthorities.add(cert);
        }
        return this;
    }

    public CertificateChainVerifier withCertificateRepository(CertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
        return this;
    }

    public CertificateChainVerifier withCertificateAuthorityCache(Map<String, X509Certificate> certificateAuthorityCache) {
        this.certificateAuthorityCache = certificateAuthorityCache;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws CertificateException {
        if (this.certificateChain == null || this.certificateChain.length < 1) {
            throw new CertificateException("Certificate chain empty");
        }
        if (this.checkDate) {
            for (X509Certificate x509Certificate : this.certificateChain) {
                Date[] dateArray = this.dates;
                int n = dateArray.length;
                for (int i = 0; i < n; ++i) {
                    Date date = dateArray[i];
                    x509Certificate.checkValidity(date);
                }
            }
        }
        for (X509Certificate x509Certificate : this.certificateChain) {
            this.checkRevoked(x509Certificate);
        }
        try {
            for (int i = 0; i < this.certificateChain.length - 1; ++i) {
                if (this.checkSigningFlag && !CertificateUtil.isUsedForSigning(this.certificateChain[i + 1])) {
                    throw new CertificateException("Certificate is not verified for signing");
                }
                this.certificateChain[i].verify(this.certificateChain[i + 1].getPublicKey());
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException("Certificate chain is not valid", e);
        }
        if (this.noCaCheck) {
            return;
        }
        X509Certificate firstCertificate = this.certificateChain[this.certificateChain.length - 1];
        String firstCertificateHash = null;
        if (this.certificateAuthorityCache != null) {
            try {
                X509Certificate certificateAuthority;
                firstCertificateHash = ByteUtil.toHexString((byte[])HashUtil.generateHash((byte[])firstCertificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA256));
                Map<String, X509Certificate> map = this.certificateAuthorityCache;
                synchronized (map) {
                    certificateAuthority = this.certificateAuthorityCache.get(firstCertificateHash);
                }
                if (certificateAuthority != null) {
                    try {
                        if (this.checkDate) {
                            for (Date date : this.dates) {
                                certificateAuthority.checkValidity(date);
                            }
                        }
                        firstCertificate.verify(certificateAuthority.getPublicKey());
                        return;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception certificateAuthority) {
                // empty catch block
            }
        }
        if (this.certificateRepository != null) {
            try {
                for (String string : this.certificateRepository.getAliases()) {
                    try {
                        X509Certificate x509Certificate = (X509Certificate)this.certificateRepository.getCertificate(string);
                        if (this.checkDate) {
                            for (Date date : this.dates) {
                                x509Certificate.checkValidity(date);
                            }
                        }
                        this.checkRevoked(x509Certificate);
                        firstCertificate.verify(x509Certificate.getPublicKey());
                        if (firstCertificateHash != null) {
                            Map<String, X509Certificate> map = this.certificateAuthorityCache;
                            synchronized (map) {
                                this.certificateAuthorityCache.put(firstCertificateHash, x509Certificate);
                            }
                        }
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception e) {
                log.trace("Error checking system CA keystore", (Throwable)e);
            }
        }
        if (CollectionUtil.isNotEmpty(this.certificateAuthorities)) {
            for (X509Certificate x509Certificate : this.certificateAuthorities) {
                try {
                    if (this.checkDate) {
                        for (Date date : this.dates) {
                            x509Certificate.checkValidity(date);
                        }
                    }
                    this.checkRevoked(x509Certificate);
                    firstCertificate.verify(x509Certificate.getPublicKey());
                    if (firstCertificateHash != null) {
                        Map<String, X509Certificate> map = this.certificateAuthorityCache;
                        synchronized (map) {
                            this.certificateAuthorityCache.put(firstCertificateHash, x509Certificate);
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                }
            }
        }
        throw new CertificateException("Certificate is not trust worthy");
    }

    protected void checkRevoked(X509Certificate certificate) throws CertificateException {
        if (this.revokedCertificateChecker != null && this.revokedCertificateChecker.isCertificateRevoked(certificate)) {
            throw new CertificateException("Certificate revoked");
        }
    }
}

