/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class MapUtil {
    private MapUtil() {
    }

    public static boolean isEmpty(Map<?, ?> map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static boolean containsKey(Map<?, ?> map, Object key) {
        if (map == null) {
            return false;
        }
        return map.containsKey(key);
    }

    public static boolean doesNotContainsKey(Map<?, ?> map, Object key) {
        return !MapUtil.containsKey(map, key);
    }

    public static boolean containsValue(Map<?, ?> map, Object value) {
        if (map == null) {
            return false;
        }
        return map.containsValue(value);
    }

    public static boolean doesNotContainsValue(Map<?, ?> map, Object value) {
        return !MapUtil.containsValue(map, value);
    }

    public static String toMapString(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder text = new StringBuilder();
        text.append("[");
        boolean firstEntry = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                text.append(", ");
            }
            if (entry.getKey() == null) {
                text.append("null");
            } else {
                text.append(entry.getKey().toString());
            }
            text.append(":");
            if (entry.getValue() == null) {
                text.append("null");
                continue;
            }
            text.append(entry.getValue().toString());
        }
        text.append("]");
        return text.toString();
    }

    public static <K, V> Map<K, V> generateMap(Object ... values) {
        if (values.length == 0) {
            return new LinkedHashMap();
        }
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("Values need to be provided in pairs");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        boolean oddItem = true;
        Object key = null;
        for (Object value : values) {
            if (oddItem) {
                key = value;
            } else {
                map.put(key, value);
            }
            oddItem = !oddItem;
        }
        return map;
    }

    public static boolean equalBasedOnItems(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 == null) {
            return false;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map1.entrySet()) {
            if (!map2.containsKey(entry.getKey())) {
                return false;
            }
            Object value = map2.get(entry.getKey());
            if (Objects.equals(entry.getValue(), value)) continue;
            return false;
        }
        return true;
    }
}

