/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.service;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.service.ExceptionGenerator;
import si.nevensrok.common.service.MethodWrapperConfig;

public class ServiceWrapper {
    private static final Logger log = LoggerFactory.getLogger(ServiceWrapper.class);
    private ExceptionGenerator exceptionGenerator = null;
    private boolean logDuration = true;
    private boolean logError = true;
    private boolean logInputAndOutputData = false;

    public void setExceptionGenerator(ExceptionGenerator exceptionGenerator) {
        this.exceptionGenerator = exceptionGenerator;
    }

    public void setLogDuration(boolean logDuration) {
        this.logDuration = logDuration;
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    public void setLogInputAndOutputData(boolean logInputAndOutputData) {
        this.logInputAndOutputData = logInputAndOutputData;
    }

    public Object processRequest(ProceedingJoinPoint point) throws Throwable {
        long startTime;
        String name;
        Throwable error;
        Object result;
        block8: {
            if (!this.isTrack(point)) {
                return point.proceed();
            }
            result = null;
            error = null;
            name = point.getTarget() + "->" + point.getSignature().getName();
            if (this.logInputAndOutputData && log.isTraceEnabled()) {
                Map<String, Object> inputData = this.generateInputData(point);
                log.trace("Service [{}] called with input data: {}", (Object)name, inputData);
            }
            startTime = System.currentTimeMillis();
            try {
                result = point.proceed();
            }
            catch (Throwable e) {
                error = e;
                if (!this.logError || !this.isLogError(point)) break block8;
                log.trace("Service [" + name + "] terminated with error", e);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        if (this.logDuration) {
            log.trace("Method [{}] execution time: {} millis", (Object)name, (Object)duration);
        }
        if (error != null) {
            if (this.exceptionGenerator != null) {
                throw this.exceptionGenerator.generateException(error);
            }
            throw error;
        }
        if (this.logInputAndOutputData) {
            log.trace("Service [{}] executed with result: {}", (Object)name, result);
        }
        return result;
    }

    private boolean isTrack(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof MethodWrapperConfig)) continue;
                MethodWrapperConfig methodWrapperConfig = (MethodWrapperConfig)annotation;
                return methodWrapperConfig.value();
            }
        }
        return true;
    }

    private boolean isLogError(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof MethodWrapperConfig)) continue;
                MethodWrapperConfig methodWrapperConfig = (MethodWrapperConfig)annotation;
                return methodWrapperConfig.logError();
            }
        }
        return true;
    }

    private Map<String, Object> generateInputData(ProceedingJoinPoint point) {
        LinkedHashMap<String, Object> inputData = new LinkedHashMap<String, Object>();
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            String[] names = methodSignature.getParameterNames();
            for (int i = 0; i < names.length; ++i) {
                Object value = point.getArgs()[i];
                inputData.put(names[i], value);
            }
        }
        return inputData;
    }
}

