/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.fw;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import si.nevensrok.common.remoting.HttpServiceProxyFactoryBean;
import si.nevensrok.jtekma.common.fightinfo.CurrentMatchInfo;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.services.FightInfoService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class FightInfoServiceClient
implements FightInfoService,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(FightInfoServiceClient.class);
    private int connectTimeout = 10000;
    private int readTimeout = 60000;
    private FightInfoService fightInfoService = null;
    private List<DisposableBean> beansToClose = new LinkedList<DisposableBean>();

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void destroy() throws Exception {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.fightInfoService = null;
    }

    public void setup(String url) {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.fightInfoService = null;
        if (!url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
            throw new RuntimeException("Unsupported protocol for URL " + url);
        }
        LOGGER.debug("Setting up HTTP invoker");
        HttpServiceProxyFactoryBean factoryBean = new HttpServiceProxyFactoryBean();
        factoryBean.setEndpoint(url);
        factoryBean.setServiceName("FightInfoService");
        factoryBean.setServiceInterface(FightInfoService.class);
        factoryBean.setConnectTimeout(this.connectTimeout);
        factoryBean.setReadTimeout(this.readTimeout);
        factoryBean.afterPropertiesSet();
        this.fightInfoService = (FightInfoService)factoryBean.getObject();
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        if (this.fightInfoService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.fightInfoService.checkLogin(credentials);
    }

    public List<CurrentMatchInfo> getCurrentFightsInfo(Credentials credentials) throws ServiceException {
        if (this.fightInfoService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.fightInfoService.getCurrentFightsInfo(credentials);
    }

    public TatamiFightData getTatamiFightData(Credentials credentials) throws ServiceException {
        if (this.fightInfoService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.fightInfoService.getTatamiFightData(credentials);
    }
}

