/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.AddressNetworkMessageSender;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.udp.AbstractMessagesReceiver;
import si.nevensrok.common.utils.ObjectUtil;

public abstract class AbstractNetworkClient
extends AbstractMessagesReceiver
implements AddressNetworkMessageSender,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNetworkClient.class);
    private Integer localPort;
    private String address;
    private Integer port;
    protected Object senderMonitor = new Object();

    @Override
    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    protected DatagramPacket generateDatagramPacket(String address, int port, byte[] data) throws Exception {
        return new DatagramPacket(data, data.length, InetAddress.getByName(address), port);
    }

    @Override
    public void sendMessage(Object object) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.getPort() == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        this.sendMessage(this.getAddress(), (int)this.getPort(), object);
    }

    @Override
    public void sendMessage(byte[] data) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.getPort() == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        this.sendMessage(this.getAddress(), (int)this.getPort(), data);
    }

    @Override
    public void sendMessage(int port, Object object) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(this.getAddress(), port, data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    @Override
    public void sendMessage(int port, byte[] data) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        this.sendMessage(this.getAddress(), port, data);
    }

    @Override
    public void sendMessage(String address, int port, Object object) throws NetworkException {
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(address, port, data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(String address, int port, byte[] data) throws NetworkException {
        if (this.socket == null) {
            throw new NetworkException("Socket is closed");
        }
        try {
            DatagramPacket packet = this.generateDatagramPacket(address, port, data);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Sending message to {}:{}, message data: {}", new Object[]{address, port, packet.getData()});
            }
            Object object = this.senderMonitor;
            synchronized (object) {
                this.socket.send(packet);
            }
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }
}

