/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import si.nevensrok.jtekma.common.matches.MatchFinishData;
import si.nevensrok.jtekma.common.matches.MatchPartialData;
import si.nevensrok.jtekma.common.matches.NextMatchData;
import si.nevensrok.jtekma.services.TablaService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class TablaServiceClient
implements TablaService,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablaServiceClient.class);
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor;
    private TablaService tablaService = null;
    private List<DisposableBean> beansToClose = new LinkedList<DisposableBean>();

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public void destroy() throws Exception {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.tablaService = null;
    }

    public void setup(String url) {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.tablaService = null;
        if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting up HTTP invoker");
            }
        } else {
            throw new RuntimeException("Unsupported protocol for URL " + url);
        }
        HttpInvokerProxyFactoryBean factoryBean = new HttpInvokerProxyFactoryBean();
        factoryBean.setServiceUrl(url + "/TablaService");
        factoryBean.setServiceInterface(TablaService.class);
        factoryBean.setHttpInvokerRequestExecutor(this.httpInvokerRequestExecutor);
        factoryBean.afterPropertiesSet();
        this.tablaService = (TablaService)factoryBean.getObject();
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        if (this.tablaService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.tablaService.checkLogin(credentials);
    }

    public NextMatchData getNextMatch(Credentials credentials) throws ServiceException {
        if (this.tablaService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.tablaService.getNextMatch(credentials);
    }

    public void setPartialData(Credentials credentials, MatchPartialData matchPartialData) {
        if (this.tablaService == null) {
            throw new RuntimeException("Not connected");
        }
        this.tablaService.setPartialData(credentials, matchPartialData);
    }

    public void finishMatch(Credentials credentials, MatchFinishData matchFinishData) throws ServiceException {
        if (this.tablaService == null) {
            throw new RuntimeException("Not connected");
        }
        this.tablaService.finishMatch(credentials, matchFinishData);
    }
}

