/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public final class CalendarUtils {
    private CalendarUtils() {
    }

    public static List<Date[]> generateDates(Date from, Date to, Period period, TimeZone timeZone) {
        Calendar fromCalendar = Calendar.getInstance(timeZone);
        fromCalendar.setTime(from);
        Calendar toCalendar = Calendar.getInstance(timeZone);
        toCalendar.setTime(to);
        LinkedList<Date[]> dates = new LinkedList<Date[]>();
        for (Calendar[] calendars : CalendarUtils.generateDates(fromCalendar, toCalendar, period, timeZone)) {
            dates.add(new Date[]{calendars[0].getTime(), calendars[1].getTime()});
        }
        return dates;
    }

    public static List<Calendar[]> generateDates(Calendar from, Calendar to, Period period, TimeZone timeZone) {
        LinkedList<Calendar[]> dates;
        block46: {
            Calendar calendarStart;
            block52: {
                block51: {
                    block50: {
                        block49: {
                            block48: {
                                block47: {
                                    block45: {
                                        dates = new LinkedList<Calendar[]>();
                                        if (from.getTimeInMillis() > to.getTimeInMillis()) {
                                            return dates;
                                        }
                                        calendarStart = Calendar.getInstance(timeZone);
                                        calendarStart.setTimeInMillis(from.getTimeInMillis());
                                        calendarStart.setFirstDayOfWeek(from.getFirstDayOfWeek());
                                        if (period != Period.MINUTELY) break block45;
                                        Calendar finishDate = Calendar.getInstance(timeZone);
                                        finishDate.setTimeInMillis(to.getTimeInMillis());
                                        finishDate.set(13, 0);
                                        finishDate.set(14, 999);
                                        finishDate.set(13, finishDate.getActualMaximum(13));
                                        calendarStart.set(13, 0);
                                        calendarStart.set(14, 0);
                                        Calendar calendarEnd = (Calendar)calendarStart.clone();
                                        calendarEnd.set(13, 0);
                                        calendarEnd.set(14, 999);
                                        calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                                        while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                                            dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                                            calendarStart.add(12, 1);
                                            calendarEnd = (Calendar)calendarStart.clone();
                                            calendarEnd.set(13, 0);
                                            calendarEnd.set(14, 999);
                                            calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                                        }
                                        break block46;
                                    }
                                    if (period != Period.QUARTER_HOURLY) break block47;
                                    Calendar finishDate = Calendar.getInstance(timeZone);
                                    finishDate.setTimeInMillis(to.getTimeInMillis());
                                    if (finishDate.get(12) <= 14) {
                                        finishDate.set(12, 14);
                                    } else if (finishDate.get(12) <= 29) {
                                        finishDate.set(12, 29);
                                    } else if (finishDate.get(12) <= 44) {
                                        finishDate.set(12, 44);
                                    } else {
                                        finishDate.set(12, 59);
                                    }
                                    finishDate.set(13, 0);
                                    finishDate.set(14, 999);
                                    finishDate.set(13, finishDate.getActualMaximum(13));
                                    if (calendarStart.get(12) <= 14) {
                                        calendarStart.set(12, 0);
                                    } else if (calendarStart.get(12) <= 29) {
                                        calendarStart.set(12, 15);
                                    } else if (calendarStart.get(12) <= 44) {
                                        calendarStart.set(12, 30);
                                    } else {
                                        calendarStart.set(12, 45);
                                    }
                                    calendarStart.set(13, 0);
                                    calendarStart.set(14, 0);
                                    Calendar calendarEnd = (Calendar)calendarStart.clone();
                                    if (calendarEnd.get(12) <= 14) {
                                        calendarEnd.set(12, 14);
                                    } else if (calendarEnd.get(12) <= 29) {
                                        calendarEnd.set(12, 29);
                                    } else if (calendarEnd.get(12) <= 44) {
                                        calendarEnd.set(12, 44);
                                    } else {
                                        calendarEnd.set(12, 59);
                                    }
                                    calendarEnd.set(13, 0);
                                    calendarEnd.set(14, 999);
                                    calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                                    while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                                        dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                                        calendarStart.add(12, 15);
                                        calendarEnd = (Calendar)calendarStart.clone();
                                        if (calendarEnd.get(12) <= 14) {
                                            calendarEnd.set(12, 14);
                                        } else if (calendarEnd.get(12) <= 29) {
                                            calendarEnd.set(12, 29);
                                        } else if (calendarEnd.get(12) <= 44) {
                                            calendarEnd.set(12, 44);
                                        } else {
                                            calendarEnd.set(12, 59);
                                        }
                                        calendarEnd.set(13, 0);
                                        calendarEnd.set(14, 999);
                                        calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                                    }
                                    break block46;
                                }
                                if (period != Period.HALF_HOURLY) break block48;
                                Calendar finishDate = Calendar.getInstance(timeZone);
                                finishDate.setTimeInMillis(to.getTimeInMillis());
                                if (finishDate.get(12) <= 29) {
                                    finishDate.set(12, 29);
                                } else {
                                    finishDate.set(12, 59);
                                }
                                finishDate.set(13, 0);
                                finishDate.set(14, 999);
                                finishDate.set(13, finishDate.getActualMaximum(13));
                                if (calendarStart.get(12) <= 29) {
                                    calendarStart.set(12, 0);
                                } else {
                                    calendarStart.set(12, 30);
                                }
                                calendarStart.set(13, 0);
                                calendarStart.set(14, 0);
                                Calendar calendarEnd = (Calendar)calendarStart.clone();
                                if (calendarEnd.get(12) <= 29) {
                                    calendarEnd.set(12, 29);
                                } else {
                                    calendarEnd.set(12, 59);
                                }
                                calendarEnd.set(13, 0);
                                calendarEnd.set(14, 999);
                                calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                                while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                                    dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                                    calendarStart.add(12, 30);
                                    calendarEnd = (Calendar)calendarStart.clone();
                                    if (calendarEnd.get(12) <= 29) {
                                        calendarEnd.set(12, 29);
                                    } else {
                                        calendarEnd.set(12, 59);
                                    }
                                    calendarEnd.set(13, 0);
                                    calendarEnd.set(14, 999);
                                    calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                                }
                                break block46;
                            }
                            if (period != Period.HOURLY) break block49;
                            Calendar finishDate = Calendar.getInstance(timeZone);
                            finishDate.setTimeInMillis(to.getTimeInMillis());
                            finishDate.set(12, 59);
                            finishDate.set(13, 0);
                            finishDate.set(14, 999);
                            finishDate.set(13, finishDate.getActualMaximum(13));
                            calendarStart.set(12, 0);
                            calendarStart.set(13, 0);
                            calendarStart.set(14, 0);
                            Calendar calendarEnd = (Calendar)calendarStart.clone();
                            calendarEnd.set(12, 59);
                            calendarEnd.set(13, 0);
                            calendarEnd.set(14, 999);
                            calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                            while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                                dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                                calendarStart.add(11, 1);
                                calendarEnd = (Calendar)calendarStart.clone();
                                calendarEnd.set(12, 59);
                                calendarEnd.set(13, 0);
                                calendarEnd.set(14, 999);
                                calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                            }
                            break block46;
                        }
                        if (period != Period.DAILY) break block50;
                        Calendar finishDate = Calendar.getInstance(timeZone);
                        finishDate.setTimeInMillis(to.getTimeInMillis());
                        finishDate.set(11, 23);
                        finishDate.set(12, 59);
                        finishDate.set(13, 0);
                        finishDate.set(14, 999);
                        finishDate.set(13, finishDate.getActualMaximum(13));
                        calendarStart.set(11, 0);
                        calendarStart.set(12, 0);
                        calendarStart.set(13, 0);
                        calendarStart.set(14, 0);
                        Calendar calendarEnd = (Calendar)calendarStart.clone();
                        calendarEnd.set(11, 23);
                        calendarEnd.set(12, 59);
                        calendarEnd.set(13, 0);
                        calendarEnd.set(14, 999);
                        calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                        while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                            dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                            calendarStart.add(6, 1);
                            calendarEnd = (Calendar)calendarStart.clone();
                            calendarEnd.set(11, 23);
                            calendarEnd.set(12, 59);
                            calendarEnd.set(13, 0);
                            calendarEnd.set(14, 999);
                            calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                        }
                        break block46;
                    }
                    if (period != Period.WEEKLY) break block51;
                    Calendar finishDate = Calendar.getInstance(timeZone);
                    finishDate.setTimeInMillis(to.getTimeInMillis());
                    finishDate.setFirstDayOfWeek(calendarStart.getFirstDayOfWeek());
                    if (calendarStart.getFirstDayOfWeek() == 1) {
                        finishDate.set(7, 7);
                    } else {
                        finishDate.set(7, calendarStart.getFirstDayOfWeek() - 1);
                    }
                    finishDate.set(11, 23);
                    finishDate.set(12, 59);
                    finishDate.set(13, 0);
                    finishDate.set(14, 999);
                    finishDate.set(13, finishDate.getActualMaximum(13));
                    calendarStart.set(7, calendarStart.getFirstDayOfWeek());
                    calendarStart.set(11, 0);
                    calendarStart.set(12, 0);
                    calendarStart.set(13, 0);
                    calendarStart.set(14, 0);
                    Calendar calendarEnd = (Calendar)calendarStart.clone();
                    if (calendarStart.getFirstDayOfWeek() == 1) {
                        calendarEnd.set(7, 7);
                    } else {
                        calendarEnd.set(7, calendarStart.getFirstDayOfWeek() - 1);
                    }
                    calendarEnd.set(11, 23);
                    calendarEnd.set(12, 59);
                    calendarEnd.set(13, 0);
                    calendarEnd.set(14, 999);
                    calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                    while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                        dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                        calendarStart.add(3, 1);
                        calendarEnd.add(3, 1);
                        if (!calendarEnd.before(calendarStart)) continue;
                        calendarEnd.add(3, 1);
                    }
                    break block46;
                }
                if (period != Period.MONTHLY) break block52;
                Calendar finishDate = Calendar.getInstance(timeZone);
                finishDate.setTimeInMillis(to.getTimeInMillis());
                finishDate.set(5, finishDate.getActualMaximum(5));
                finishDate.set(11, 23);
                finishDate.set(12, 59);
                finishDate.set(13, 0);
                finishDate.set(14, 999);
                finishDate.set(13, finishDate.getActualMaximum(13));
                calendarStart.set(5, 1);
                calendarStart.set(11, 0);
                calendarStart.set(12, 0);
                calendarStart.set(13, 0);
                calendarStart.set(14, 0);
                Calendar calendarEnd = (Calendar)calendarStart.clone();
                calendarEnd.set(5, calendarEnd.getActualMaximum(5));
                calendarEnd.set(11, 23);
                calendarEnd.set(12, 59);
                calendarEnd.set(13, 0);
                calendarEnd.set(14, 999);
                calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                    dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                    calendarStart.add(2, 1);
                    calendarEnd = (Calendar)calendarStart.clone();
                    calendarEnd.set(5, calendarEnd.getActualMaximum(5));
                    calendarEnd.set(11, 23);
                    calendarEnd.set(12, 59);
                    calendarEnd.set(13, 0);
                    calendarEnd.set(14, 999);
                    calendarEnd.set(13, calendarEnd.getActualMaximum(13));
                }
                break block46;
            }
            if (period != Period.YEARLY) break block46;
            Calendar finishDate = Calendar.getInstance(timeZone);
            finishDate.setTimeInMillis(to.getTimeInMillis());
            finishDate.set(6, finishDate.getActualMaximum(6));
            finishDate.set(11, 23);
            finishDate.set(12, 59);
            finishDate.set(13, 0);
            finishDate.set(14, 999);
            finishDate.set(13, finishDate.getActualMaximum(13));
            calendarStart.set(6, 1);
            calendarStart.set(11, 0);
            calendarStart.set(12, 0);
            calendarStart.set(13, 0);
            calendarStart.set(14, 0);
            Calendar calendarEnd = (Calendar)calendarStart.clone();
            calendarEnd.set(6, calendarEnd.getActualMaximum(6));
            calendarEnd.set(11, 23);
            calendarEnd.set(12, 59);
            calendarEnd.set(13, 0);
            calendarEnd.set(14, 999);
            calendarEnd.set(13, calendarEnd.getActualMaximum(13));
            while (calendarEnd.getTimeInMillis() <= finishDate.getTimeInMillis()) {
                dates.add(new Calendar[]{(Calendar)calendarStart.clone(), (Calendar)calendarEnd.clone()});
                calendarStart.add(1, 1);
                calendarEnd = (Calendar)calendarStart.clone();
                calendarEnd.set(6, calendarEnd.getActualMaximum(6));
                calendarEnd.set(11, 23);
                calendarEnd.set(12, 59);
                calendarEnd.set(13, 0);
                calendarEnd.set(14, 999);
                calendarEnd.set(13, calendarEnd.getActualMaximum(13));
            }
        }
        return dates;
    }

    public static Date toStartOfDay(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return CalendarUtils.toStartOfDay(calendar).getTime();
    }

    public static Date toEndOfDay(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return CalendarUtils.toEndOfDay(calendar).getTime();
    }

    public static Calendar toStartOfDay(Calendar date) {
        Calendar calendar = (Calendar)date.clone();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar toEndOfDay(Calendar date) {
        Calendar calendar = (Calendar)date.clone();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 0);
        calendar.set(14, 999);
        calendar.set(13, calendar.getActualMaximum(13));
        return calendar;
    }

    public static enum Period {
        MINUTELY,
        QUARTER_HOURLY,
        HALF_HOURLY,
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }
}

