/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.formatter;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.common.web.formatter.AbstractFormatterFactory;
import si.nevensrok.common.web.formatter.DateFormatter;
import si.nevensrok.common.web.formatter.TimezoneResolver;

public class DateFormatterFactory
extends AbstractFormatterFactory<DateFormatter> {
    private TimezoneResolver timezoneResolver;

    public void setTimezoneResolver(TimezoneResolver timezoneResolver) {
        this.timezoneResolver = timezoneResolver;
    }

    public DateFormatterFactory() {
        super(new Class[]{Date.class, Calendar.class, Instant.class, Long.class, Long.TYPE, BigInteger.class});
    }

    public Printer<?> getPrinter(final DateFormatter annotation, Class<?> fieldType) {
        if (Date.class.isAssignableFrom(fieldType)) {
            return new Printer<Date>(){

                public String print(Date date, Locale locale) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.format(date);
                }
            };
        }
        if (Calendar.class.isAssignableFrom(fieldType)) {
            return new Printer<Calendar>(){

                public String print(Calendar date, Locale locale) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.format(date.getTime());
                }
            };
        }
        if (Instant.class.isAssignableFrom(fieldType)) {
            return new Printer<Instant>(){

                public String print(Instant date, Locale locale) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.format(new Date(date.toEpochMilli()));
                }
            };
        }
        if (Long.class.isAssignableFrom(fieldType)) {
            return new Printer<Long>(){

                public String print(Long date, Locale locale) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.format(new Date(date));
                }
            };
        }
        if (BigInteger.class.isAssignableFrom(fieldType)) {
            return new Printer<BigInteger>(){

                public String print(BigInteger date, Locale locale) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.format(new Date(date.longValue()));
                }
            };
        }
        throw new RuntimeException("Printer not found for type " + fieldType.getName());
    }

    public Parser<?> getParser(final DateFormatter annotation, Class<?> fieldType) {
        if (Date.class.isAssignableFrom(fieldType)) {
            return new Parser<Date>(){

                public Date parse(String text, Locale locale) throws ParseException {
                    if (StringUtil.isBlank((String)text)) {
                        return null;
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.parse(text.trim());
                }
            };
        }
        if (Calendar.class.isAssignableFrom(fieldType)) {
            return new Parser<Calendar>(){

                public Calendar parse(String text, Locale locale) throws ParseException {
                    Calendar calendar;
                    if (StringUtil.isBlank((String)text)) {
                        return null;
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                        calendar = Calendar.getInstance(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    } else {
                        calendar = Calendar.getInstance();
                    }
                    Date date = dateFormat.parse(text.trim());
                    calendar.setTime(date);
                    return calendar;
                }
            };
        }
        if (Instant.class.isAssignableFrom(fieldType)) {
            return new Parser<Instant>(){

                public Instant parse(String text, Locale locale) throws ParseException {
                    if (StringUtil.isBlank((String)text)) {
                        return null;
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    Date date = dateFormat.parse(text.trim());
                    return Instant.ofEpochMilli(date.getTime());
                }
            };
        }
        if (Long.class.isAssignableFrom(fieldType)) {
            return new Parser<Long>(){

                public Long parse(String text, Locale locale) throws ParseException {
                    if (StringUtil.isBlank((String)text)) {
                        return null;
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.parse(text.trim()).getTime();
                }
            };
        }
        if (BigInteger.class.isAssignableFrom(fieldType)) {
            return new Parser<BigInteger>(){

                public BigInteger parse(String text, Locale locale) throws ParseException {
                    if (StringUtil.isBlank((String)text)) {
                        return null;
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return new BigInteger(String.valueOf(dateFormat.parse(text.trim()).getTime()));
                }
            };
        }
        throw new RuntimeException("Parser not found for type " + fieldType.getName());
    }
}

