/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchDetail;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchPointDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.PointDetailDTO;

public class MatchDAO
extends ExtendedDao<Long, MatchDTO, Match> {
    public MatchDAO() {
        super(MatchDTO.class, Match.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("matchId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("competitor1")) {
            return "competitor1.id";
        }
        if (fieldName.equalsIgnoreCase("competitor2")) {
            return "competitor2.id";
        }
        if (fieldName.equalsIgnoreCase("category")) {
            return "category.id";
        }
        if (fieldName.equalsIgnoreCase("status")) {
            return "status";
        }
        if (fieldName.equalsIgnoreCase("type")) {
            return "type";
        }
        if (fieldName.equalsIgnoreCase("fightNumber")) {
            return "fightNumber";
        }
        if (fieldName.equalsIgnoreCase("noWinner")) {
            return "noWinner";
        }
        if (fieldName.equalsIgnoreCase("notNeeded")) {
            return "notNeeded";
        }
        if (fieldName.equalsIgnoreCase("matchEmpty")) {
            return "matchEmpty";
        }
        if (fieldName.equalsIgnoreCase("startedAt")) {
            return "startedAt";
        }
        if (fieldName.equalsIgnoreCase("finishedAt")) {
            return "finishedAt";
        }
        if (fieldName.equalsIgnoreCase("matchDuration")) {
            return "matchDuration";
        }
        if (fieldName.equalsIgnoreCase("fightTimeLeft")) {
            return "fightTimeLeft";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public Match getByIdWithCompetitors(Long matchId) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select match,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor1.id) as competitor1,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor2.id) as competitor2 from MatchDTO as match where match.id=");
        sql.append(params.addParam(matchId));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        Object[] parts = (Object[])MatchDAO.getSingleResult((Query)query);
        Match match = null;
        if (parts != null) {
            match = (Match)this.getAdapterPool().create(Match.class, parts[0]);
            Competitor competitor1 = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            Competitor competitor2 = (Competitor)this.getAdapterPool().create(Competitor.class, parts[2]);
            match.setCompetitor1(competitor1);
            match.setCompetitor2(competitor2);
        }
        this.flush();
        return match;
    }

    public List<Match> getMatchesForCategory(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select match,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor1.id) as competitor1,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor2.id) as competitor2 from MatchDTO as match where match.category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" order by match.fightNumber");
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Match> matches = new LinkedList<Match>();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            Match match = (Match)this.getAdapterPool().create(Match.class, parts[0]);
            Competitor competitor1 = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            Competitor competitor2 = (Competitor)this.getAdapterPool().create(Competitor.class, parts[2]);
            match.setCompetitor1(competitor1);
            match.setCompetitor2(competitor2);
            matches.add(match);
        }
        this.flush();
        return matches;
    }

    public Match getMatchForCategory(Category category, int matchNumber) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select match,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor1.id) as competitor1,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor2.id) as competitor2 from MatchDTO as match where match.category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and match.fightNumber=");
        sql.append(params.addParam(Integer.valueOf(matchNumber)));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        Object[] parts = (Object[])MatchDAO.getSingleResult((Query)query);
        Match match = null;
        if (parts != null) {
            match = (Match)this.getAdapterPool().create(Match.class, parts[0]);
            Competitor competitor1 = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            Competitor competitor2 = (Competitor)this.getAdapterPool().create(Competitor.class, parts[2]);
            match.setCompetitor1(competitor1);
            match.setCompetitor2(competitor2);
        }
        this.flush();
        return match;
    }

    public void setMatchCompetitors(Match match, Competitor competitor1, Competitor competitor2) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set competitor1=");
        if (competitor1 == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(competitor1.getCompetitorId()));
        }
        sql.append(",competitor2=");
        if (competitor2 == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(competitor2.getCompetitorId()));
        }
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Set<MatchPoint> getMatchPointsForMatch(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select matchPoint from MatchPointDTO as matchPoint where matchPoint.match.id=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        HashSet<MatchPoint> matchPoints = new HashSet<MatchPoint>();
        for (Object item : list) {
            MatchPoint matchPoint = (MatchPoint)this.getAdapterPool().create(MatchPoint.class, item);
            matchPoints.add(matchPoint);
        }
        this.flush();
        return matchPoints;
    }

    public Map<Match, Set<MatchPoint>> getMatchPointsForMatches(Set<Match> matches) {
        if (matches.isEmpty()) {
            return new HashMap<Match, Set<MatchPoint>>();
        }
        HashMap<Long, Match> matchesMap = new HashMap<Long, Match>();
        HashMap<Match, Set<MatchPoint>> matchPoints = new HashMap<Match, Set<MatchPoint>>();
        for (Match match : matches) {
            matchesMap.put(match.getMatchId(), match);
            matchPoints.put(match, new HashSet());
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select matchPoint.match.id,matchPoint from MatchPointDTO as matchPoint where matchPoint.match.id in ");
        sql.append(params.addParam(matchesMap.keySet()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            Long matchId = (Long)parts[0];
            MatchPoint matchPoint = (MatchPoint)this.getAdapterPool().create(MatchPoint.class, parts[1]);
            ((Set)matchPoints.get(matchesMap.get(matchId))).add(matchPoint);
        }
        this.flush();
        return matchPoints;
    }

    public void setMatchPointsForMatch(Match match, Set<MatchPoint> points) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from MatchPointDTO where match.matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        MatchDTO matchDTO = new MatchDTO();
        matchDTO.setMatchId(match.getMatchId());
        for (MatchPoint matchPoint : points) {
            MatchPointDTO matchPointDTO = (MatchPointDTO)this.getAdapterPool().create(MatchPointDTO.class, (Object)matchPoint);
            matchPointDTO.setMatch(matchDTO);
            this.getCurrentSession().save((Object)matchPointDTO);
        }
        this.flush();
    }

    public Set<PointDetail> getMatchPointDetailsForMatch(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select pointDetail from PointDetailDTO as pointDetail where pointDetail.match.id=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        HashSet<PointDetail> pointDetails = new HashSet<PointDetail>();
        for (Object item : list) {
            PointDetail pointDetail = (PointDetail)this.getAdapterPool().create(PointDetail.class, item);
            pointDetails.add(pointDetail);
        }
        this.flush();
        return pointDetails;
    }

    public Map<Match, Set<PointDetail>> getMatchPointDetailsForMatches(Set<Match> matches) {
        if (matches.isEmpty()) {
            return new HashMap<Match, Set<PointDetail>>();
        }
        HashMap<Long, Match> matchesMap = new HashMap<Long, Match>();
        HashMap<Match, Set<PointDetail>> matchPointDetails = new HashMap<Match, Set<PointDetail>>();
        for (Match match : matches) {
            matchesMap.put(match.getMatchId(), match);
            matchPointDetails.put(match, new HashSet());
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select pointDetail.match.id,pointDetail from PointDetailDTO as pointDetail where pointDetail.match.id in ");
        sql.append(params.addParam(matchesMap.keySet()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        for (Object[] parts : list) {
            Long matchId = (Long)parts[0];
            PointDetail pointDetail = (PointDetail)this.getAdapterPool().create(PointDetail.class, parts[1]);
            ((Set)matchPointDetails.get(matchesMap.get(matchId))).add(pointDetail);
        }
        this.flush();
        return matchPointDetails;
    }

    public void setMatchPointDetailsForMatch(Match match, Set<PointDetail> pointDetails) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from PointDetailDTO where match.matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        MatchDTO matchDTO = new MatchDTO();
        matchDTO.setMatchId(match.getMatchId());
        for (PointDetail pointDetail : pointDetails) {
            PointDetailDTO pointDetailDTO = (PointDetailDTO)this.getAdapterPool().create(PointDetailDTO.class, (Object)pointDetail);
            pointDetailDTO.setMatch(matchDTO);
            this.getCurrentSession().save((Object)pointDetailDTO);
        }
        this.flush();
    }

    public void setMatchStatus(Match match, Match.Status status) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set status=");
        sql.append(params.addParam((Object)status));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void updateMatchTreeAdvancmentData(Collection<Match> matches) {
        for (Match match : matches) {
            ParamsBinder params = new ParamsBinder();
            StringBuilder sql = new StringBuilder();
            sql.append("update MatchDTO set competitor1=");
            if (match.getCompetitor1() == null) {
                sql.append(params.addParam(null));
            } else {
                sql.append(params.addParam(match.getCompetitor1().getCompetitorId()));
            }
            sql.append(",competitor2=");
            if (match.getCompetitor2() == null) {
                sql.append(params.addParam(null));
            } else {
                sql.append(params.addParam(match.getCompetitor2().getCompetitorId()));
            }
            sql.append(",notNeeded=");
            sql.append(params.addParam(match.getNotNeeded()));
            sql.append(",matchEmpty=");
            sql.append(params.addParam(match.getMatchEmpty()));
            sql.append(" where matchId=");
            sql.append(params.addParam(match.getMatchId()));
            Query query = this.createQuery(sql.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        this.flush();
    }

    public Collection<Match> createMatches(Collection<Match> matches) {
        for (Match match : matches) {
            MatchDTO matchDTO = (MatchDTO)this.getAdapterPool().create(MatchDTO.class, (Object)match);
            matchDTO = (MatchDTO)super.createInstance((Object)matchDTO);
            match.setId(matchDTO.getId());
        }
        this.flush();
        return matches;
    }

    public void deleteMatch(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from MatchPointDTO where match.id=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("delete from PointDetailDTO where match.id=");
        sql.append(params.addParam(match.getMatchId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("delete from FightOrderDTO where match.id=");
        sql.append(params.addParam(match.getMatchId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("delete from MatchDTO where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Integer getMatchCount(Competition competition, Set<Match.Status> statuses, boolean excludeNotNeeded) {
        if (statuses.isEmpty()) {
            return 0;
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from MatchDTO as match where match.category.competition.id=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(" and match.category.status=");
        sql.append(params.addParam((Object)Category.Status.ACTIVE));
        sql.append(" and match.status in ");
        sql.append(params.addParam(statuses));
        if (excludeNotNeeded) {
            sql.append(" and match.notNeeded=");
            sql.append(params.addParam(Boolean.FALSE));
        }
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        Long count = (Long)MatchDAO.getSingleResult((Query)query);
        this.flush();
        return count.intValue();
    }

    public Integer getMatchCount(Category category, Set<Match.Status> statuses, boolean excludeNotNeeded) {
        if (statuses.isEmpty()) {
            return 0;
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from MatchDTO as match where match.category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and match.category.status=");
        sql.append(params.addParam((Object)Category.Status.ACTIVE));
        sql.append(" and match.status in ");
        sql.append(params.addParam(statuses));
        if (excludeNotNeeded) {
            sql.append(" and match.notNeeded=");
            sql.append(params.addParam(Boolean.FALSE));
        }
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        Long count = (Long)MatchDAO.getSingleResult((Query)query);
        this.flush();
        return count.intValue();
    }

    public Map<Competitor, Set<MatchDetail>> getMatchDetailsForCompetitors(Set<Competitor> competitors) {
        HashMap<Competitor, Set<MatchDetail>> matchDetails = new HashMap<Competitor, Set<MatchDetail>>();
        if (competitors.isEmpty()) {
            return matchDetails;
        }
        HashMap<Long, Competitor> competitorsById = new HashMap<Long, Competitor>();
        for (Competitor competitor : competitors) {
            competitorsById.put(competitor.getCompetitorId(), competitor);
            matchDetails.put(competitor, new HashSet());
        }
        HashMap<Long, MatchDetail> matchDetailsById = new HashMap<Long, MatchDetail>();
        int competitorCount = 0;
        HashSet<Long> competitorIds = new HashSet<Long>();
        for (Competitor competitor : competitors) {
            competitorIds.add(competitor.getCompetitorId());
            if (++competitorCount % 800 != 0 && competitorCount != competitors.size()) continue;
            ParamsBinder params = new ParamsBinder();
            StringBuilder sql = new StringBuilder();
            sql.append("select match,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor1.id) as competitor1,(select competitor from CompetitorDTO as competitor where competitor.id=match.competitor2.id) as competitor2 from MatchDTO as match where match.status=");
            sql.append(params.addParam((Object)Match.Status.FINISHED));
            sql.append(" and (match.competitor1.id in ");
            sql.append(params.addParam(competitorIds));
            sql.append(" or match.competitor2.id in ");
            sql.append(params.addParam(competitorIds));
            sql.append(")");
            Query query = this.createQuery(sql.toString());
            params.bindParams(query);
            List list = query.getResultList();
            for (Object[] parts : list) {
                Set details;
                Match match = (Match)this.getAdapterPool().create(Match.class, parts[0]);
                match.setCompetitor1((Competitor)this.getAdapterPool().create(Competitor.class, parts[1]));
                match.setCompetitor2((Competitor)this.getAdapterPool().create(Competitor.class, parts[2]));
                MatchDetail matchDetail = new MatchDetail();
                matchDetail.setMatch(match);
                matchDetail.setMatchPoints(new HashSet());
                matchDetailsById.put(match.getMatchId(), matchDetail);
                if (match.getCompetitor1() != null && (details = (Set)matchDetails.get(competitorsById.get(match.getCompetitor1().getCompetitorId()))) != null) {
                    details.add(matchDetail);
                }
                if (match.getCompetitor2() == null || (details = (Set)matchDetails.get(competitorsById.get(match.getCompetitor2().getCompetitorId()))) == null) continue;
                details.add(matchDetail);
            }
            competitorIds.clear();
        }
        this.flush();
        HashSet<Long> matchIds = new HashSet<Long>();
        int matchCount = 0;
        for (Long matchId : matchDetailsById.keySet()) {
            matchIds.add(matchId);
            if (++matchCount % 800 != 0 && matchCount != matchDetailsById.size()) continue;
            ParamsBinder params = new ParamsBinder();
            StringBuilder sql = new StringBuilder();
            sql.append("select matchPoint.match.id,matchPoint from MatchPointDTO as matchPoint where matchPoint.match.id in ");
            sql.append(params.addParam(matchIds));
            Query query = this.createQuery(sql.toString());
            params.bindParams(query);
            List list = query.getResultList();
            for (Object[] parts : list) {
                Long id = (Long)parts[0];
                MatchPoint matchPoint = (MatchPoint)this.getAdapterPool().create(MatchPoint.class, parts[1]);
                ((MatchDetail)matchDetailsById.get(id)).getMatchPoints().add(matchPoint);
            }
            matchIds.clear();
        }
        this.flush();
        return matchDetails;
    }

    public void setMatchStartedAt(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set startedAt=");
        sql.append(params.addParam(match.getStartedAt()));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setMatchFinishedAt(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set finishedAt=");
        sql.append(params.addParam(match.getFinishedAt()));
        sql.append(",matchDuration=");
        sql.append(params.addParam(match.getMatchDuration()));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setFightTimeLeft(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set fightTimeLeft=");
        sql.append(params.addParam(match.getFightTimeLeft()));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setHosekomiTime(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set hosekomiTime=");
        sql.append(params.addParam(match.getHosekomiTime()));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setInjuryTime(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set injuryTime1=");
        sql.append(params.addParam(match.getInjuryTime1()));
        sql.append(",injuryTime2=");
        sql.append(params.addParam(match.getInjuryTime2()));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setChallenges(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set challengesWon1=");
        sql.append(params.addParam(match.getChallengesWon1()));
        sql.append(",challengesWon2=");
        sql.append(params.addParam(match.getChallengesWon2()));
        sql.append(",challengesLost1=");
        sql.append(params.addParam(match.getChallengesLost1()));
        sql.append(",challengesLost2=");
        sql.append(params.addParam(match.getChallengesLost2()));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setNoWinner(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set noWinner=");
        sql.append(params.addParam(match.getNoWinner()));
        sql.append(" where matchId=");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }
}

