/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.utils.RegexUtil;
import si.nevensrok.common.x509cert.CertificateUtil;
import sun.security.x509.X500Name;

public class CertificateHostnameVerifier
implements HostnameVerifier {
    private static final Logger log = LoggerFactory.getLogger(CertificateHostnameVerifier.class);
    private boolean allowAll = false;
    private boolean allowWildmarks = true;

    public CertificateHostnameVerifier() {
    }

    public CertificateHostnameVerifier(boolean allowAll) {
        this.allowAll = allowAll;
    }

    public CertificateHostnameVerifier(boolean allowAll, boolean allowWildmarks) {
        this.allowAll = allowAll;
        this.allowWildmarks = allowWildmarks;
    }

    @Override
    public boolean verify(String hostname, SSLSession sslSession) {
        if (this.allowAll) {
            return true;
        }
        try {
            X509Certificate certificate = (X509Certificate)sslSession.getPeerCertificates()[0];
            try {
                List<String> alternativeNames = CertificateUtil.getAlternativeNames(certificate);
                for (String alternativeName : alternativeNames) {
                    if (this.allowWildmarks) {
                        String regex = RegexUtil.createWildcardRegex((String)alternativeName);
                        if (!hostname.toLowerCase().matches(regex.toLowerCase())) continue;
                        return true;
                    }
                    if (!hostname.equalsIgnoreCase(alternativeName)) continue;
                    return true;
                }
            }
            catch (Exception alternativeNames) {
                // empty catch block
            }
            X500Name name = (X500Name)certificate.getSubjectDN();
            String commonName = name.getCommonName();
            if (this.allowWildmarks) {
                String regex = RegexUtil.createWildcardRegex((String)commonName);
                return hostname.toLowerCase().matches(regex.toLowerCase());
            }
            return hostname.equalsIgnoreCase(commonName);
        }
        catch (Exception e) {
            log.error("Error verifing hostname", (Throwable)e);
            return false;
        }
    }
}

