/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import si.nevensrok.common.ssl.BcCertificateChainVerifier;
import si.nevensrok.common.ssl.BcCertificateRepository;
import si.nevensrok.common.ssl.BcRevokedCertificateChecker;
import si.nevensrok.common.ssl.BcTrustManager;

public class BcTrustManagerImpl
implements BcTrustManager {
    private boolean trustAll = false;
    private boolean checkDate = true;
    private boolean checkHostname = true;
    private boolean checkSigningFlag = true;
    private BcCertificateRepository certificateRepository;
    private BcRevokedCertificateChecker revokedCertificateChecker;

    public BcTrustManagerImpl() {
    }

    public BcTrustManagerImpl(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public BcTrustManagerImpl(BcCertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    public BcCertificateRepository getCertificateRepository() {
        return this.certificateRepository;
    }

    public void setCertificateRepository(BcCertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    public void setRevokedCertificateChecker(BcRevokedCertificateChecker revokedCertificateChecker) {
        this.revokedCertificateChecker = revokedCertificateChecker;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public boolean isCheckDate() {
        return this.checkDate;
    }

    public void setCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
    }

    public boolean isCheckHostname() {
        return this.checkHostname;
    }

    public void setCheckHostname(boolean checkHostname) {
        this.checkHostname = checkHostname;
    }

    public boolean isCheckSigningFlag() {
        return this.checkSigningFlag;
    }

    public void setCheckSigningFlag(boolean checkSigningFlag) {
        this.checkSigningFlag = checkSigningFlag;
    }

    @Override
    public void checkCertificateTrusted(TlsCertificate[] chain) throws CertificateException {
        if (chain.length < 1) {
            throw new CertificateException("Certificate chain empty");
        }
        if (this.trustAll) {
            return;
        }
        if (this.certificateRepository == null) {
            throw new CertificateException("Certificate repository empty");
        }
        new BcCertificateChainVerifier().withCheckDate(this.checkDate).withCheckSigningFlag(this.checkSigningFlag).withCertificateChain(chain).withRevokedCertificateChecker(this.revokedCertificateChecker).withCertificateRepository(this.certificateRepository).check();
    }

    @Override
    public List<Certificate> getAcceptedIssuers() {
        LinkedList<Certificate> trustedSigners = new LinkedList<Certificate>();
        if (this.certificateRepository == null) {
            return trustedSigners;
        }
        for (String alias : this.certificateRepository.getAliases()) {
            Certificate certificate = this.certificateRepository.getCertificate(alias);
            if (this.revokedCertificateChecker != null && this.revokedCertificateChecker.isCertificateRevoked(certificate)) continue;
            trustedSigners.add(certificate);
        }
        return trustedSigners;
    }
}

