/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.threads;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.threads.PeriodicJobStatus;
import si.nevensrok.common.threads.ThreadUtil;

public class PeriodicJobStatusImpl
implements PeriodicJobStatus {
    private static final Logger log = LoggerFactory.getLogger(PeriodicJobStatusImpl.class);
    private Object monitor = new Object();
    private Calendar lastRunDate;
    private Long lastExecutionTime;
    private long numberOfExecutions = 0L;
    private boolean active = true;

    PeriodicJobStatusImpl(final long timeout, final Runnable runnable, boolean daemon) {
        Thread thread = new Thread(ThreadUtil.generateThreadName("Periodic job thread-")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (PeriodicJobStatusImpl.this.active) {
                        PeriodicJobStatusImpl.this.lastRunDate = Calendar.getInstance();
                        long startTime = System.currentTimeMillis();
                        runnable.run();
                        long endTime = System.currentTimeMillis();
                        PeriodicJobStatusImpl.this.numberOfExecutions = PeriodicJobStatusImpl.this.numberOfExecutions + 1L;
                        PeriodicJobStatusImpl.this.lastExecutionTime = endTime - startTime;
                        if (PeriodicJobStatusImpl.this.lastExecutionTime < 0L) {
                            PeriodicJobStatusImpl.this.lastExecutionTime = 0L;
                        }
                        Object object = PeriodicJobStatusImpl.this.monitor;
                        synchronized (object) {
                            try {
                                if (PeriodicJobStatusImpl.this.active && timeout > 0L) {
                                    PeriodicJobStatusImpl.this.monitor.wait(timeout);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    return;
                }
                catch (Throwable e) {
                    log.error("Error executing periodic job", e);
                }
            }
        };
        thread.setDaemon(daemon);
        thread.start();
    }

    @Override
    public Calendar getLastRunDate() {
        return this.lastRunDate;
    }

    @Override
    public Long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    @Override
    public long getNumberOfExecutions() {
        return this.numberOfExecutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            this.active = false;
            this.monitor.notifyAll();
        }
    }
}

