/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.Vector;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.BcKeyManager;
import si.nevensrok.common.ssl.BcTrustManager;

public class CustomTlsClient
extends DefaultTlsClient {
    private static final Logger log = LoggerFactory.getLogger(CustomTlsClient.class);
    private BcTrustManager trustManager;
    private BcKeyManager keyManager;
    private TlsCertificate serverCertificate;
    private boolean sslSessionValid = false;

    public CustomTlsClient() {
        super((TlsCrypto)new BcTlsCrypto(new SecureRandom()));
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        log.trace("NotifyAlertRaised: " + message, cause);
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        log.trace("NotifyAlertReceived");
    }

    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
    }

    public void setTrustManager(BcTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setKeyManager(BcKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public TlsCertificate getServerCertificate() {
        return this.serverCertificate;
    }

    public void setServerCertificate(TlsCertificate serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public void notifyHandshakeComplete() throws IOException {
        this.sslSessionValid = true;
    }

    public boolean isSslSessionValid() {
        return this.sslSessionValid;
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                TlsCertificate[] tlsCertificates = CustomTlsClient.this.getTlsCertificates(serverCertificate);
                if (serverCertificate == null || tlsCertificates.length == 0) {
                    throw new IOException("Server certificate validation failed");
                }
                if (CustomTlsClient.this.trustManager != null) {
                    try {
                        CustomTlsClient.this.trustManager.checkCertificateTrusted(tlsCertificates);
                        CustomTlsClient.this.setServerCertificate(tlsCertificates[0]);
                    }
                    catch (CertificateException e) {
                        throw new IOException("Server certificate validation failed");
                    }
                } else {
                    throw new IOException("Server certificate validation failed");
                }
            }

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                try {
                    if (CustomTlsClient.this.keyManager != null) {
                        LinkedList<String> keyTypes = new LinkedList<String>();
                        if (certificateRequest.getCertificateTypes() != null) {
                            for (short keyType : certificateRequest.getCertificateTypes()) {
                                if (keyType == 1) {
                                    keyTypes.add("RSA");
                                    continue;
                                }
                                if (keyType == 2) {
                                    keyTypes.add("DSA");
                                    continue;
                                }
                                if (keyType != 64) continue;
                                keyTypes.add("EC");
                            }
                        }
                        LinkedList<X500Name> certificateAuthorities = new LinkedList<X500Name>();
                        for (Object ca : certificateRequest.getCertificateAuthorities()) {
                            certificateAuthorities.add((X500Name)ca);
                        }
                        String alias = CustomTlsClient.this.keyManager.chooseAlias(keyTypes, certificateAuthorities);
                        if (alias != null) {
                            BcTlsCertificate[] certificateChain = CustomTlsClient.this.keyManager.getCertificateChain(alias);
                            AsymmetricKeyParameter privateKey = CustomTlsClient.this.keyManager.getPrivateKey(alias);
                            Certificate certificate = new Certificate((TlsCertificate[])certificateChain);
                            SignatureAndHashAlgorithm signatureAndHashAlgorithm = CustomTlsClient.this.getSignatureAndHashAlgorithm(certificateChain[0]);
                            BcTlsCrypto bcTlsCrypto = (BcTlsCrypto)CustomTlsClient.this.context.getCrypto();
                            return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)CustomTlsClient.this.context), bcTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Error loading rsa encryption credentials", (Throwable)e);
                }
                return null;
            }
        };
    }

    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
    }

    protected TlsCertificate[] getTlsCertificates(TlsServerCertificate serverCertificate) {
        Certificate certificate = serverCertificate.getCertificate();
        TlsCertificate[] tlsCertificates = new TlsCertificate[certificate.getLength()];
        for (int i = 0; i < certificate.getLength(); ++i) {
            tlsCertificates[i] = certificate.getCertificateAt(i);
        }
        return tlsCertificates;
    }

    protected SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(BcTlsCertificate certificate) {
        String algorithmIdentifier = certificate.getSigAlgOID();
        if ("1.2.840.113549.1.1.4".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(1, 1);
        }
        if ("1.2.840.113549.1.1.5".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(2, 1);
        }
        if ("1.2.840.113549.1.1.11".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(4, 1);
        }
        if ("1.2.840.113549.1.1.12".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(5, 1);
        }
        if ("1.2.840.113549.1.1.13".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(6, 1);
        }
        if ("1.2.840.113549.1.1.14".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(3, 1);
        }
        throw new IllegalArgumentException("Unsupported signature algorithm: " + algorithmIdentifier);
    }
}

