/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.gui.HelpDialog;
import si.nevensrok.jtekma.tabla.gui.InfoPanel;
import si.nevensrok.jtekma.tabla.gui.InjuryTimeDialog;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.SettingsDialog;
import si.nevensrok.jtekma.tabla.gui.SystemInfoDialog;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;
import si.nevensrok.jtekma.utils.gui.CredentialsDialog;

public class WindowKeyListener
implements KeyListener,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowKeyListener.class);
    private static final NumberFormat SECONDS_NUMBER_FORMAT = new DecimalFormat("00");
    private ApplicationContext applicationContext;
    private MatchPanel matchPanel;
    private TablaWindow tablaWindow;
    private MatchData matchData;
    private TimeTracker timeTracker;
    private InfoPanel infoPanel;
    private TablaManager tablaManager;
    private HelpDialog helpDialog;
    private SettingsDialog settingsDialog;
    private SystemInfoDialog systemInfoDialog;
    private InjuryTimeDialog injuryTimeDialog;
    private String defaultServiceUrl = null;
    private boolean broadcasterEnable = false;
    private int broadcasterPort = 12701;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchPanel(MatchPanel matchPanel) {
        this.matchPanel = matchPanel;
    }

    public void setTablaWindow(TablaWindow tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    public void setInfoPanel(InfoPanel infoPanel) {
        this.infoPanel = infoPanel;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setHelpDialog(HelpDialog helpDialog) {
        this.helpDialog = helpDialog;
    }

    public void setSettingsDialog(SettingsDialog settingsDialog) {
        this.settingsDialog = settingsDialog;
    }

    public void setSystemInfoDialog(SystemInfoDialog systemInfoDialog) {
        this.systemInfoDialog = systemInfoDialog;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public void setDefaultServiceUrl(String defaultServiceUrl) {
        this.defaultServiceUrl = defaultServiceUrl;
    }

    public void setBroadcasterEnable(boolean broadcasterEnable) {
        this.broadcasterEnable = broadcasterEnable;
    }

    public void setBroadcasterPort(int broadcasterPort) {
        this.broadcasterPort = broadcasterPort;
    }

    public void setInjuryTimeDialog(InjuryTimeDialog injuryTimeDialog) {
        this.injuryTimeDialog = injuryTimeDialog;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        block84: {
            LOGGER.trace("Key pressed: [{}] - [{}]", (Object)e.getKeyCode(), (Object)Character.valueOf(e.getKeyChar()));
            if (e.getKeyCode() == 112) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WindowKeyListener.this.helpDialog.setVisible(true);
                        WindowKeyListener.this.helpDialog.requestFocus();
                    }
                });
            }
            if (e.getKeyCode() == 113) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WindowKeyListener.this.systemInfoDialog.setVisible(true);
                        WindowKeyListener.this.systemInfoDialog.requestFocus();
                    }
                });
            } else if (e.getKeyCode() == 114) {
                if (JOptionPane.showConfirmDialog(this.tablaWindow, this.getLanguageText("text.resetMatch"), this.getLanguageText("title.confirmation"), 1, 2) == 0) {
                    this.tablaManager.resetTable();
                }
            } else if (e.getKeyCode() == 115) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.tablaManager.selectWinner();
            } else if (e.getKeyCode() == 116) {
                this.matchPanel.redrawElements();
            } else if (e.getKeyCode() == 119) {
                this.settingsDialog.setVisible(true);
            } else if (e.getKeyCode() == 120) {
                if (this.matchData.getCredentials() != null) {
                    if (JOptionPane.showConfirmDialog(this.tablaWindow, this.getLanguageText("text.disconnect"), this.getLanguageText("title.confirmation"), 1, 2) != 0) {
                        return;
                    }
                    this.matchData.setCredentials(null);
                }
                String buildVersion = "";
                ClassPathResource gitFileResource = new ClassPathResource("/git.properties");
                if (gitFileResource.exists()) {
                    try {
                        Properties properties = new Properties();
                        properties.load(gitFileResource.getInputStream());
                        buildVersion = (String)properties.get("git.commit.id.describe");
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Error reading git build info", (Throwable)ex);
                    }
                }
                try {
                    Credentials credentials;
                    HashMap<String, String> messages = new HashMap<String, String>();
                    messages.put("title", this.getLanguageText("title.login"));
                    messages.put("url", this.getLanguageText("text.url"));
                    messages.put("username", this.getLanguageText("text.username"));
                    messages.put("password", this.getLanguageText("text.password"));
                    messages.put("login", this.getLanguageText("text.login"));
                    messages.put("cancel", this.getLanguageText("text.cancel"));
                    messages.put("buildVersion", this.getLanguageText("systemInfo.version"));
                    messages.put("buildVersionDisplay", buildVersion);
                    messages.put("defaultServiceUrl", this.defaultServiceUrl);
                    if (this.broadcasterEnable) {
                        messages.put("broadcaster.port", String.valueOf(this.broadcasterPort));
                    }
                    if ((credentials = CredentialsDialog.showDialog((Frame)this.tablaWindow, messages)) == null) break block84;
                    if (this.tablaManager.checkLogin(credentials)) {
                        this.matchData.setCredentials(credentials);
                        JOptionPane.showMessageDialog(this.tablaWindow, this.getLanguageText("text.loginSuccess"), this.getLanguageText("title.info"), 1);
                        break block84;
                    }
                    JOptionPane.showMessageDialog(this.tablaWindow, this.getLanguageText("text.invalidCredentials"), this.getLanguageText("title.error"), 0);
                }
                catch (Exception ex) {
                    LOGGER.error("Error while checking login", (Throwable)ex);
                    JOptionPane.showMessageDialog(this.tablaWindow, this.getLanguageText("text.errorConnectionToServer"), this.getLanguageText("title.error"), 0);
                }
            } else if (e.getKeyCode() == 122) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                if (this.matchData.getCredentials() == null) {
                    JOptionPane.showMessageDialog(this.tablaWindow, this.getLanguageText("text.notConnected"), this.getLanguageText("title.error"), 0);
                    return;
                }
                this.tablaManager.fetchNextMatch();
            } else if (e.getKeyCode() == 123) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.tablaManager.finishMatch();
            } else if (e.getKeyCode() == 27 || e.getKeyCode() == 88) {
                if (JOptionPane.showConfirmDialog(this.tablaWindow, this.getLanguageText("text.exit"), this.getLanguageText("title.confirmation"), 1, 2) == 0) {
                    if (this.applicationContext instanceof AbstractApplicationContext) {
                        AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)this.applicationContext;
                        abstractApplicationContext.close();
                    } else {
                        LOGGER.warn("Can't destroy application context. Stopping java proccess");
                    }
                    System.exit(0);
                }
            } else if (e.getKeyCode() == 82) {
                this.tablaWindow.resetWindowLocation();
            } else if (e.getKeyCode() == 84) {
                if (this.matchData.getMatch() == null) {
                    this.timeTracker.stopTime();
                    this.timeTracker.stopHosekomiTime();
                    if (this.matchData.getTableType() == TableType.FIGHT) {
                        this.matchData.setTableType(TableType.DUO);
                    } else if (this.matchData.getTableType() == TableType.DUO) {
                        this.tablaWindow.requestFocus();
                        this.matchData.setTableType(TableType.NEWAZA);
                    } else {
                        this.matchData.setTableType(TableType.FIGHT);
                    }
                    this.matchPanel.redrawElements();
                    this.tablaManager.recalculatePoints();
                }
            } else if (e.getKeyCode() == 81) {
                String text = JOptionPane.showInputDialog(this.tablaWindow, this.getLanguageText("text.enterName1"), this.matchData.getName1());
                if (text != null) {
                    this.matchData.setName1(text);
                    this.matchPanel.redrawElements();
                }
            } else if (e.getKeyCode() == 87) {
                String text = JOptionPane.showInputDialog(this.tablaWindow, this.getLanguageText("text.enterClub1"), this.matchData.getClub1());
                if (text != null) {
                    this.matchData.setClub1(text);
                    this.matchPanel.redrawElements();
                }
            } else if (e.getKeyCode() == 65) {
                String text = JOptionPane.showInputDialog(this.tablaWindow, this.getLanguageText("text.enterName2"), this.matchData.getName2());
                if (text != null) {
                    this.matchData.setName2(text);
                    this.matchPanel.redrawElements();
                }
            } else if (e.getKeyCode() == 83) {
                String text = JOptionPane.showInputDialog(this.tablaWindow, this.getLanguageText("text.enterClub2"), this.matchData.getClub2());
                if (text != null) {
                    this.matchData.setClub2(text);
                    this.matchPanel.redrawElements();
                }
            } else if (e.getKeyCode() == 80) {
                if (this.matchData.getTableType() != TableType.FIGHT && this.matchData.getTableType() != TableType.NEWAZA) {
                    return;
                }
                this.timeTracker.startStopTime();
            } else if (e.getKeyCode() == 79) {
                if (this.matchData.getTableType() != TableType.FIGHT && this.matchData.getTableType() != TableType.NEWAZA) {
                    return;
                }
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                long time = this.matchData.getTimeLeft() / 1000L;
                long minutes = time / 60L;
                long seconds = time % 60L;
                String timeText = String.valueOf(minutes) + ":" + SECONDS_NUMBER_FORMAT.format(seconds);
                timeText = JOptionPane.showInputDialog(this.tablaWindow, this.getLanguageText("text.enterTime"), timeText);
                if (timeText != null) {
                    try {
                        String[] parts = timeText.split(":");
                        if (parts.length > 1) {
                            minutes = Long.parseLong(parts[0].trim());
                            seconds = Long.parseLong(parts[1].trim());
                        } else {
                            minutes = 0L;
                            seconds = Long.parseLong(parts[0].trim());
                        }
                        this.matchData.setTimeLeft((minutes * 60L + seconds) * 1000L);
                        this.infoPanel.redrawElements();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while parsing time", (Throwable)ex);
                    }
                }
            } else if (e.getKeyCode() == 76) {
                if (this.matchData.getTableType() != TableType.FIGHT && this.matchData.getTableType() != TableType.NEWAZA) {
                    return;
                }
                this.timeTracker.startStopHosekomiTime();
            } else if (e.getKeyCode() == 75) {
                if (this.matchData.getTableType() != TableType.FIGHT && this.matchData.getTableType() != TableType.NEWAZA) {
                    return;
                }
                this.timeTracker.stopHosekomiTime();
                for (int i = this.matchData.getLastHostkomis().length - 1; i > 0; --i) {
                    this.matchData.getLastHostkomis()[i] = this.matchData.getLastHostkomis()[i - 1];
                }
                this.matchData.getLastHostkomis()[0] = this.matchData.getHosekomiTime();
                this.matchData.setHosekomiTime(0L);
                this.infoPanel.redrawElements();
            } else if (e.getKeyCode() == 74) {
                if (this.matchData.getTableType() != TableType.FIGHT && this.matchData.getTableType() != TableType.NEWAZA) {
                    return;
                }
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                long time = this.matchData.getHosekomiTime() / 1000L;
                String timeText = SECONDS_NUMBER_FORMAT.format(time);
                timeText = JOptionPane.showInputDialog(this.tablaWindow, this.getLanguageText("text.enterHosekomiTime"), timeText);
                if (timeText != null) {
                    try {
                        time = Long.parseLong(timeText.trim());
                        this.matchData.setHosekomiTime(time * 1000L);
                        this.infoPanel.redrawElements();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while parsing hosekomi time", (Throwable)ex);
                    }
                }
            } else if (e.getKeyCode() == 77) {
                String text = JOptionPane.showInputDialog(this.tablaWindow, this.getLanguageText("text.enterCategory"), this.matchData.getCategory());
                if (text != null) {
                    this.matchData.setCategory(text.trim());
                    this.infoPanel.redrawElements();
                }
            } else if (e.getKeyCode() == 70) {
                this.matchData.setFlipCompetitors(!this.matchData.isFlipCompetitors());
                this.matchPanel.redrawElements();
            } else if (e.getKeyCode() == 85) {
                this.injuryTimeDialog.setVisible(true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

