/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.services.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.fightinfo.CurrentMatchInfo;
import si.nevensrok.jtekma.common.fightinfo.FightInfo;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchDetail;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.common.tatami.TatamiFightOrder;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.FightInfoManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.services.FightInfoService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class FightInfoServiceImpl
implements FightInfoService {
    private FightInfoManager fightInfoManager;
    private TatamiManager tatamiManager;
    private CompetitionManager competitionManager;
    private MatchManager matchManager;
    private CategoryManager categoryManager;

    public void setFightInfoManager(FightInfoManager fightInfoManager) {
        this.fightInfoManager = fightInfoManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        FightInfo fightInfo = this.fightInfoManager.getFightInfoByCredentials(credentials);
        return fightInfo != null;
    }

    public List<CurrentMatchInfo> getCurrentFightsInfo(Credentials credentials) throws ServiceException {
        FightInfo fightInfo = this.fightInfoManager.getFightInfoByCredentials(credentials);
        if (fightInfo == null) {
            throw new ServiceException("Invalid credentials");
        }
        Competition competition = this.competitionManager.getCompetitionForFightInfo(fightInfo);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFetchCount(false);
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult dataResult = this.tatamiManager.find(competition, (DataFilter)dataFilter);
        LinkedList<CurrentMatchInfo> currentMatchInfoList = new LinkedList<CurrentMatchInfo>();
        for (Tatami tatami : dataResult.getData()) {
            FightOrder fightOrder;
            Match match;
            List fightOrderList = this.tatamiManager.getFightOrderForTatami(tatami, 1);
            CurrentMatchInfo currentMatchInfo = new CurrentMatchInfo();
            currentMatchInfoList.add(currentMatchInfo);
            currentMatchInfo.setTatami(tatami);
            currentMatchInfo.setRules(competition.getRules());
            if (fightOrderList.isEmpty() || (match = (fightOrder = (FightOrder)fightOrderList.get(0)).getMatch()) == null) continue;
            match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
            match.setCategory(this.categoryManager.getCategoryForMatch(match));
            currentMatchInfo.setMatchDetail(new MatchDetail());
            currentMatchInfo.getMatchDetail().setMatch(match);
            Set matchPoints = this.matchManager.getMatchPointsForMatch(match);
            currentMatchInfo.getMatchDetail().setMatchPoints(matchPoints);
        }
        return currentMatchInfoList;
    }

    public TatamiFightData getTatamiFightData(Credentials credentials) throws ServiceException {
        FightInfo fightInfo = this.fightInfoManager.getFightInfoByCredentials(credentials);
        if (fightInfo == null) {
            throw new ServiceException("Invalid credentials");
        }
        Competition competition = this.competitionManager.getCompetitionForFightInfo(fightInfo);
        TatamiFightData tatamiFightData = new TatamiFightData();
        tatamiFightData.setDisplayRows(Integer.valueOf(1));
        LinkedList<TatamiFightOrder> tatamiFightOrders = new LinkedList<TatamiFightOrder>();
        tatamiFightData.setTatamiFightOrders(tatamiFightOrders);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFetchCount(false);
        List tatamis = this.tatamiManager.find(competition, (DataFilter)dataFilter).getData();
        Collections.sort(tatamis, new Comparator<Tatami>(){

            @Override
            public int compare(Tatami o1, Tatami o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Tatami tatami : tatamis) {
            TatamiFightOrder tatamiFightOrder = new TatamiFightOrder();
            tatamiFightOrders.add(tatamiFightOrder);
            tatami.setPassword(null);
            tatamiFightOrder.setTatami(tatami);
            tatamiFightOrder.setFightOrders(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : tatamiFightOrder.getFightOrders()) {
                Match match = fightOrder.getMatch();
                if (match == null) continue;
                match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
                fightOrder.setMatch(match);
                Category category = this.categoryManager.getCategoryForMatch(match);
                match.setCategory(category);
            }
        }
        return tatamiFightData;
    }
}

