/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.documents.DocumentCreator;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.club.ClubCompetitorPoints;
import si.nevensrok.jtekma.common.club.ClubPlacing;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.ClubManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.reports.DocumentType;
import si.nevensrok.jtekma.server.reports.ReportGenerator;
import si.nevensrok.jtekma.server.reports.impl.CategoryData;
import si.nevensrok.jtekma.server.reports.impl.CategoryPlacingData;
import si.nevensrok.jtekma.server.reports.impl.DocumentGenerator;
import si.nevensrok.jtekma.server.reports.impl.MatchData;
import si.nevensrok.jtekma.server.reports.impl.PlacingData;
import si.nevensrok.jtekma.server.tools.MatchNumberTool;

public class DocumentReportGenerator
implements ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(DocumentReportGenerator.class);
    private static final DecimalFormat fightPointsFormat;
    private static final DecimalFormat duoPointsFormat;
    private static final DecimalFormat newazzaPointsFormat;
    private MessageLoader messageLoader;
    private DocumentGenerator documentGenerator;
    private DocumentCreator pdfDocumentCreator;
    private DocumentCreator odfDocumentCreator;
    private CategoryManager categoryManager;
    private CategoryTreeUpdateManager categoryTreeUpdateManager;
    private RulesManager rulesManager;
    private CompetitionManager competitionManager;
    private MatchManager matchManager;
    private ClubManager clubManager;

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public void setDocumentGenerator(DocumentGenerator documentGenerator) {
        this.documentGenerator = documentGenerator;
    }

    public void setPdfDocumentCreator(DocumentCreator pdfDocumentCreator) {
        this.pdfDocumentCreator = pdfDocumentCreator;
    }

    public void setOdfDocumentCreator(DocumentCreator odfDocumentCreator) {
        this.odfDocumentCreator = odfDocumentCreator;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCategoryTreeUpdateManager(CategoryTreeUpdateManager categoryTreeUpdateManager) {
        this.categoryTreeUpdateManager = categoryTreeUpdateManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setClubManager(ClubManager clubManager) {
        this.clubManager = clubManager;
    }

    /*
     * WARNING - void declaration
     */
    public void generateTreeReport(DocumentType documentType, Locale locale, OutputStream outputStream, List<Category> categories, boolean empty) {
        try {
            LinkedList<CategoryData> categoryDatas = new LinkedList<CategoryData>();
            for (Category category : categories) {
                Competition competition = this.competitionManager.getCompetitionForCategory(category = this.categoryManager.getFullById(category.getCategoryId()));
                CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
                if (competitionRules == null) {
                    throw new RuntimeException("CompetitionRules for competition not found");
                }
                List matchList = this.matchManager.getMatchesForCategory(category);
                HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
                for (Match match : matchList) {
                    matches.put(match.getFightNumber(), match);
                }
                String[][] tableContent = null;
                LinkedList<MatchData> matchDatas = new LinkedList<MatchData>();
                ArrayList<PlacingData> placingDatas = new ArrayList<PlacingData>();
                boolean display3rdPlaceMatch = false;
                TreeCategory.TreeType treeType = null;
                TreeCategory.RepassageType repassageType = null;
                boolean custom = true;
                if (category instanceof TreeCategory) {
                    TreeCategory treeCategory = (TreeCategory)category;
                    display3rdPlaceMatch = treeCategory.getDouble3rdPlace() == false;
                    treeType = treeCategory.getTreeType();
                    repassageType = treeCategory.getRepassageType();
                    custom = false;
                    TreeAdvancment treeAdvancment = treeCategory.getTreeAdvancment();
                    if (treeCategory.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
                        for (int i = 1; i <= 3; ++i) {
                            void var30_64;
                            Match match = (Match)matches.get(i);
                            Set set = this.matchManager.getMatchPointsForMatch(match);
                            String competitor1 = "";
                            String competitor2 = "";
                            float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, set);
                            float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, set);
                            String points1text = "";
                            String string = "";
                            if (match.getCompetitor1() != null) {
                                competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    points1text = DocumentReportGenerator.getPointsText(match, points1);
                                }
                            }
                            if (match.getCompetitor2() != null) {
                                competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    String string2 = DocumentReportGenerator.getPointsText(match, points2);
                                }
                            }
                            matchDatas.add(new MatchData(competitor1, competitor2, points1text, (String)var30_64));
                        }
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
                        Table table = this.categoryTreeUpdateManager.getTable((Category)treeCategory);
                        tableContent = new String[table.getRows().length][9];
                        int i = 0;
                        for (Table.Row row : table.getRows()) {
                            int j;
                            tableContent[i][0] = row.getCompetitor() != null ? DocumentReportGenerator.getCompetitorShortName(row.getCompetitor(), true) : "";
                            boolean atLeastOneMatchFinished = false;
                            for (j = 0; j < 5; ++j) {
                                tableContent[i][j + 1] = "";
                            }
                            j = 0;
                            for (Table.Row.Match match : row.getMatches()) {
                                String points = "";
                                if (match != null && match.getMyPoints() != null && match.getOtherPoints() != null && (match.getMyPoints().floatValue() > 0.0f || match.getOtherPoints().floatValue() > 0.0f) && !empty) {
                                    atLeastOneMatchFinished = true;
                                    if (treeCategory.getType() == Category.Type.FIGHTING) {
                                        points = fightPointsFormat.format(match.getMyPoints()) + ":" + fightPointsFormat.format(match.getOtherPoints());
                                    } else if (treeCategory.getType() == Category.Type.DUO) {
                                        points = duoPointsFormat.format(match.getMyPoints()) + ":" + duoPointsFormat.format(match.getOtherPoints());
                                    } else if (treeCategory.getType() == Category.Type.NEWAZA) {
                                        points = fightPointsFormat.format(match.getMyPoints()) + ":" + fightPointsFormat.format(match.getOtherPoints());
                                    }
                                }
                                tableContent[i][j + 1] = points;
                                ++j;
                            }
                            if (atLeastOneMatchFinished && !empty) {
                                tableContent[i][6] = row.getWins().toString();
                                tableContent[i][7] = row.getFullIpponWins().toString();
                                if (treeCategory.getType() == Category.Type.FIGHTING) {
                                    tableContent[i][8] = fightPointsFormat.format(row.getPointsGained());
                                } else if (treeCategory.getType() == Category.Type.DUO) {
                                    tableContent[i][8] = duoPointsFormat.format(row.getPointsGained());
                                } else if (treeCategory.getType() == Category.Type.NEWAZA) {
                                    tableContent[i][8] = fightPointsFormat.format(row.getPointsGained());
                                }
                            } else {
                                tableContent[i][6] = "";
                                tableContent[i][7] = "";
                                tableContent[i][8] = "";
                            }
                            ++i;
                        }
                        for (int i2 = 1; i2 <= 10; ++i2) {
                            void var30_68;
                            Match match = (Match)matches.get(i2);
                            Set set = this.matchManager.getMatchPointsForMatch(match);
                            String competitor1 = "";
                            String competitor2 = "";
                            float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, set);
                            float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, set);
                            String points1text = "";
                            String string = "";
                            if (match.getCompetitor1() != null) {
                                competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    points1text = DocumentReportGenerator.getPointsText(match, points1);
                                }
                            }
                            if (match.getCompetitor2() != null) {
                                competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    String string3 = DocumentReportGenerator.getPointsText(match, points2);
                                }
                            }
                            matchDatas.add(new MatchData(competitor1, competitor2, points1text, (String)var30_68));
                        }
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE4) {
                        this.addTreeMatches(117, 118, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(123, 124, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE8) {
                        this.addTreeMatches(105, 108, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(117, 124, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE16) {
                        this.addTreeMatches(81, 88, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(105, 124, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE32) {
                        this.addTreeMatches(33, 48, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(81, 124, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE64) {
                        this.addTreeMatches(1, 32, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(33, 124, locale, treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    }
                    if (!empty) {
                        Map placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)treeCategory);
                        for (Map.Entry entry : placingsMap.entrySet()) {
                            Competitor competitor = (Competitor)entry.getKey();
                            placingDatas.add(new PlacingData((Integer)entry.getValue(), DocumentReportGenerator.getCompetitorName(competitor)));
                        }
                        Collections.sort(placingDatas, new Comparator<PlacingData>(){

                            @Override
                            public int compare(PlacingData o1, PlacingData o2) {
                                if (o1.getPlacing() > o2.getPlacing()) {
                                    return 1;
                                }
                                if (o1.getPlacing() < o2.getPlacing()) {
                                    return -1;
                                }
                                return o1.getName().compareTo(o2.getName());
                            }
                        });
                    }
                } else {
                    ArrayList matchesForCategory = new ArrayList(matches.values());
                    Collections.sort(matchesForCategory, new Comparator<Match>(){

                        @Override
                        public int compare(Match o1, Match o2) {
                            return o1.getFightNumber().compareTo(o2.getFightNumber());
                        }
                    });
                    for (Match match : matchesForCategory) {
                        void var24_41;
                        Set matchPoints = this.matchManager.getMatchPointsForMatch(match);
                        String string = "";
                        String competitor2 = "";
                        float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, matchPoints);
                        float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, matchPoints);
                        String points1text = "";
                        String points2text = "";
                        if (match.getCompetitor1() != null) {
                            String string4 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                            if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                points1text = DocumentReportGenerator.getPointsText(match, points1);
                            }
                        }
                        if (match.getCompetitor2() != null) {
                            competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                            if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                points2text = DocumentReportGenerator.getPointsText(match, points2);
                            }
                        }
                        matchDatas.add(new MatchData("", "", (String)var24_41, competitor2, points1text, points2text, match.getFightNumber().toString()));
                    }
                }
                CategoryData categoryData = new CategoryData();
                categoryData.setCategoryName(category.getName());
                categoryData.setTableContent(tableContent);
                categoryData.setMatchDatas(matchDatas);
                categoryData.setPlacingDatas(placingDatas);
                categoryData.setDisplay3rdPlaceMatch(display3rdPlaceMatch);
                categoryData.setTreeType(treeType);
                categoryData.setRepassageType(repassageType);
                categoryData.setCustom(custom);
                categoryDatas.add(categoryData);
            }
            Document document = this.documentGenerator.generateTreeReport(locale, categoryDatas, empty);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            log.error("Error creating tree report", (Throwable)e);
        }
    }

    public void generatePlacingsReport(DocumentType documentType, Locale locale, OutputStream outputStream, List<Category> categories, boolean oneCategoryPerPage) {
        try {
            LinkedList<CategoryPlacingData> categoryPlacingDataList = new LinkedList<CategoryPlacingData>();
            for (Category category : categories) {
                Competition competition = this.competitionManager.getCompetitionForCategory(category = this.categoryManager.getFullById(category.getCategoryId()));
                CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
                if (competitionRules == null) {
                    throw new RuntimeException("CompetitionRules for competition not found");
                }
                HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
                for (Match match : this.matchManager.getMatchesForCategory(category)) {
                    matches.put(match.getFightNumber(), match);
                }
                if (!(category instanceof TreeCategory)) continue;
                TreeCategory treeCategory = (TreeCategory)category;
                Map placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)treeCategory);
                ArrayList<PlacingData> placings = new ArrayList<PlacingData>(64);
                for (Map.Entry placingEntry : placingsMap.entrySet()) {
                    Competitor competitor = (Competitor)placingEntry.getKey();
                    placings.add(new PlacingData((Integer)placingEntry.getValue(), DocumentReportGenerator.getCompetitorName(competitor)));
                }
                Collections.sort(placings, new Comparator<PlacingData>(){

                    @Override
                    public int compare(PlacingData o1, PlacingData o2) {
                        if (o1.getPlacing() > o2.getPlacing()) {
                            return 1;
                        }
                        if (o1.getPlacing() < o2.getPlacing()) {
                            return -1;
                        }
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                if (placings.isEmpty()) continue;
                CategoryPlacingData categoryPlacingData = new CategoryPlacingData(category.getName(), placings);
                categoryPlacingDataList.add(categoryPlacingData);
            }
            Document document = this.documentGenerator.generateCompetitorPlacingsDocument(locale, categoryPlacingDataList, oneCategoryPerPage);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            log.error("Error creating competitor placing report", (Throwable)e);
        }
    }

    public void generateClubPlacingsReport(DocumentType documentType, Locale locale, OutputStream outputStream, Competition competition, List<Category> categories) {
        try {
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            Map competitionSettings = this.competitionManager.getCompetitionSettings(competition);
            HashMap<Integer, Integer> pointsForPlace = new HashMap<Integer, Integer>();
            for (int i = 1; i <= 7; ++i) {
                if (competitionSettings.get("clubPlacing.points." + i) == null) continue;
                pointsForPlace.put(i, ((Long)competitionSettings.get("clubPlacing.points." + i)).intValue());
            }
            boolean includeOneCompetitor = competitionSettings.get("clubPlacing.includeOneCompetitor") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeOneCompetitor");
            boolean includeSameClub = competitionSettings.get("clubPlacing.includeSameClub") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeSameClub");
            boolean includeAllCompetitors = competitionSettings.get("clubPlacing.includeAllCompetitors") == null ? false : (Boolean)competitionSettings.get("clubPlacing.includeAllCompetitors");
            Club clubExample = new Club();
            clubExample.setStatus(Club.Status.ACTIVE);
            clubExample.setCountForClubPlacings(Boolean.TRUE);
            SimpleDataFilter clubDataFilter = new SimpleDataFilter();
            clubDataFilter.setFetchCount(false);
            clubDataFilter.setFilter((Filter)new ExampleFilter((Object)clubExample));
            clubDataFilter.setItemLimit(Integer.valueOf(1000));
            clubDataFilter.setSort(new Sort());
            clubDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
            ArrayList<ClubPlacing> clubPlacings = new ArrayList<ClubPlacing>();
            for (Club club : this.clubManager.find(competition, (DataFilter)clubDataFilter).getData()) {
                ClubPlacing clubPlacing = new ClubPlacing();
                clubPlacing.setClub(club);
                clubPlacing.setPoints(Integer.valueOf(0));
                clubPlacings.add(clubPlacing);
            }
            for (Category category : categories) {
                Map map;
                Category category2 = this.categoryManager.getById(category.getCategoryId());
                if (!(category2 instanceof TreeCategory) || (map = this.categoryTreeUpdateManager.getPlacings(category2)) == null) continue;
                for (ClubPlacing clubPlacing : clubPlacings) {
                    ClubCompetitorPoints clubCompetitorPoints = competitionRules.getPointsForClub(clubPlacing.getClub(), map, pointsForPlace, includeOneCompetitor, includeSameClub, includeAllCompetitors);
                    if (clubCompetitorPoints.getTopPlace() == 1) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_1() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 2) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_2() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 3) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_3() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 4) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_4() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 5) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_5() + 1));
                    }
                    clubPlacing.setPoints(Integer.valueOf(clubPlacing.getPoints() + clubCompetitorPoints.getPoints()));
                }
            }
            Collections.sort(clubPlacings, new Comparator<ClubPlacing>(){

                @Override
                public int compare(ClubPlacing o1, ClubPlacing o2) {
                    int n = o1.getPoints().compareTo(o2.getPoints());
                    if (n != 0) {
                        return -n;
                    }
                    n = o1.getPlace_1().compareTo(o2.getPlace_1());
                    if (n != 0) {
                        return -n;
                    }
                    n = o1.getPlace_2().compareTo(o2.getPlace_2());
                    if (n != 0) {
                        return -n;
                    }
                    n = o1.getPlace_3().compareTo(o2.getPlace_3());
                    if (n != 0) {
                        return -n;
                    }
                    n = o1.getPlace_4().compareTo(o2.getPlace_4());
                    if (n != 0) {
                        return -n;
                    }
                    n = o1.getPlace_5().compareTo(o2.getPlace_5());
                    if (n != 0) {
                        return -n;
                    }
                    return 0;
                }
            });
            int placeNum = 1;
            for (ClubPlacing clubPlacing : clubPlacings) {
                clubPlacing.setPlace(Integer.valueOf(placeNum++));
            }
            LinkedList<PlacingData> linkedList = new LinkedList<PlacingData>();
            for (ClubPlacing clubPlacing : clubPlacings) {
                linkedList.add(new PlacingData(clubPlacing.getPlace(), clubPlacing.getClub().getName(), clubPlacing.getPoints()));
            }
            Document document = this.documentGenerator.generateClubPlacingsDocument(locale, linkedList);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            log.error("Error creating club placing report", (Throwable)e);
        }
    }

    private static String getCompetitorShortName(Competitor competitor, boolean spaceBeforeClub) {
        String name = "";
        if (competitor instanceof PersonCompetitor) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            name = personCompetitor.getShortName() + (spaceBeforeClub ? " / " : "/") + personCompetitor.getClub().getShortName();
        }
        if (competitor instanceof CoupleCompetitor) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
            name = coupleCompetitor.getShortName() + (spaceBeforeClub ? " / " : "/") + coupleCompetitor.getClub().getShortName();
        }
        return name;
    }

    private static String getCompetitorName(Competitor competitor) {
        String name = "";
        if (competitor instanceof PersonCompetitor) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            name = personCompetitor.getName() + " " + personCompetitor.getSurname() + "/" + personCompetitor.getClub().getShortName();
        }
        if (competitor instanceof CoupleCompetitor) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
            name = coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + "," + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + "/" + coupleCompetitor.getClub().getName();
        }
        return name;
    }

    private static float getPointsForMatch(Match match, CompetitorType competitorType, CompetitionRules competitionRules, Set<MatchPoint> matchPoints) {
        float points = competitionRules.sumPointsFor(match.getType(), competitorType, matchPoints);
        return points;
    }

    private static String getPointsText(Match match, float points) {
        if (match.getType() == Match.Type.FIGHT) {
            return fightPointsFormat.format(points);
        }
        if (match.getType() == Match.Type.DUO) {
            return duoPointsFormat.format(points);
        }
        if (match.getType() == Match.Type.NEWAZA) {
            return newazzaPointsFormat.format(points);
        }
        return "";
    }

    private void addTreeMatches(int startNum, int endNum, Locale locale, TreeCategory treeCategory, TreeAdvancment treeAdvancment, Map<Integer, Match> matches, List<MatchData> matchDatas, MatchManager matchManager, CompetitionRules competitionRules, boolean empty, boolean displayCompetitorNames) {
        for (int i = startNum; i <= endNum; ++i) {
            TreeAdvancmentItem treeAdvancmentItem2;
            TreeAdvancmentItem treeAdvancmentItem1;
            Match match = matches.get(i);
            Set matchPoints = matchManager.getMatchPointsForMatch(match);
            String source1 = "";
            String source2 = "";
            String matchNumber = "";
            String competitor1 = "";
            String competitor2 = "";
            float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, matchPoints);
            float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, matchPoints);
            String points1text = "";
            String points2text = "";
            matchNumber = String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), match.getFightNumber()));
            if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE4) {
                if (match.getFightNumber() >= 117 && match.getFightNumber() <= 118) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 123 && match.getFightNumber() <= 123) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE8) {
                if (match.getFightNumber() >= 105 && match.getFightNumber() <= 108) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 119 && match.getFightNumber() <= 120) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE16) {
                if (match.getFightNumber() >= 81 && match.getFightNumber() <= 88) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 109 && match.getFightNumber() <= 112) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE32) {
                if (match.getFightNumber() >= 33 && match.getFightNumber() <= 48) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 89 && match.getFightNumber() <= 96) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE64) {
                if (match.getFightNumber() >= 1 && match.getFightNumber() <= 32) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 49 && match.getFightNumber() <= 64) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            }
            if (displayCompetitorNames && match.getCompetitor1() != null) {
                competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                    points1text = DocumentReportGenerator.getPointsText(match, points1);
                }
            }
            if (displayCompetitorNames && match.getCompetitor2() != null) {
                competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                    points2text = DocumentReportGenerator.getPointsText(match, points2);
                }
            }
            matchDatas.add(new MatchData(source1, source2, competitor1, competitor2, points1text, points2text, matchNumber));
        }
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        fightPointsFormat = new DecimalFormat("0");
        duoPointsFormat = new DecimalFormat("0.0", decimalFormatSymbols);
        newazzaPointsFormat = new DecimalFormat("0");
    }
}

