/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.messagesource.MessageLoader;

public class ClasspathMessageLoader
implements MessageLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathMessageLoader.class);
    private String baseName;
    private Map<Locale, ResourceBundle> boundles = new HashMap<Locale, ResourceBundle>();

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public void setMessage(Locale locale, String key, String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key) {
        Map<Locale, ResourceBundle> map = this.boundles;
        synchronized (map) {
            if (!this.boundles.containsKey(locale)) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(this.baseName, locale);
                    if (resourceBundle != null) {
                        this.boundles.put(locale, resourceBundle);
                    }
                }
                catch (MissingResourceException e) {
                    LOGGER.warn("Messages not found for locale {}", (Object)locale.getDisplayName());
                }
            }
        }
        ResourceBundle resourceBundle = this.boundles.get(locale);
        if (resourceBundle != null && resourceBundle.containsKey(key)) {
            return resourceBundle.getString(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessagePresent(Locale locale, String key) {
        Map<Locale, ResourceBundle> map = this.boundles;
        synchronized (map) {
            if (!this.boundles.containsKey(locale)) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(this.baseName, locale);
                    if (resourceBundle != null) {
                        this.boundles.put(locale, resourceBundle);
                    }
                }
                catch (MissingResourceException e) {
                    LOGGER.warn("Messages not found for locale {}", (Object)locale.getDisplayName());
                }
            }
        }
        ResourceBundle resourceBundle = this.boundles.get(locale);
        return resourceBundle != null && resourceBundle.containsKey(key);
    }
}

