/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImportUtil;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.ClubManager;
import si.nevensrok.jtekma.server.management.CompetitorManager;

public class CoupleCompetitorImporter {
    private static final Logger log = LoggerFactory.getLogger(CoupleCompetitorImporter.class);
    private static final int bufferSize = 65536;
    private CompetitorManager competitorManager;
    private ClubManager clubManager;
    private CategoryManager categoryManager;

    public void setCompetitorManager(CompetitorManager competitorManager) {
        this.competitorManager = competitorManager;
    }

    public void setClubManager(ClubManager clubManager) {
        this.clubManager = clubManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public List<Competitor> parseCompetitors(FileType fileType, byte[] fileData, Competition competition, Map<String, DataImportException.ErrorType> errors) {
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        HashMap<String, CoupleCompetitor> coupleCompetitors = new HashMap<String, CoupleCompetitor>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int firstName1Index = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime1", "Ime 1", "Ime tekmovalca1", "Ime tekmovalca 1", "Name1", "Name 1", "First name1", "First name 1"});
        int lastName1Index = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Priimek1", "Priimek 1", "Priimek tekmovalca1", "Priimek tekmovalca 1", "Surname1", "Surname 1", "Last name1", "Last name 1", "Prezime1"});
        int firstName2Index = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime2", "Ime 2", "Ime tekmovalca2", "Ime tekmovalca 2", "Name2", "Name 2", "First name2", "First name 2"});
        int lastName2Index = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Priimek2", "Priimek 2", "Priimek tekmovalca2", "Priimek tekmovalca 2", "Surname2", "Surname 2", "Last name2", "Last name 2", "Prezime2"});
        int clubNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Klub", "Ime kluba", "Club", "Club Name"});
        int categoryNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Kategorija", "Ime kategorije", "Category", "Category Name"});
        int shortNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Kratica", "Competitor Short Name", "Short Name"});
        int yearOfBirth1Index = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Leto rojstva1", "Leto rojstva 1", "Year Of Birth1", "Year Of Birth 1", "Birth year1", "Birth year 1"});
        int yearOfBirth2Index = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Leto rojstva2", "Leto rojstva 2", "Year Of Birth2", "Year Of Birth 2", "Birth year2", "Birth year 2"});
        if (firstName1Index < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCoupleName1);
        }
        if (lastName1Index < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCoupleSurname1);
        }
        if (firstName2Index < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCoupleName2);
        }
        if (lastName2Index < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCoupleSurname2);
        }
        if (clubNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCompetitorClub);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String competitorKey;
            CoupleCompetitor coupleCompetitor;
            String shortName;
            Category c;
            String firstName1 = ImportUtil.formatName(fileLine.getData(firstName1Index));
            String lastName1 = ImportUtil.formatName(fileLine.getData(lastName1Index));
            String firstName2 = ImportUtil.formatName(fileLine.getData(firstName2Index));
            String lastName2 = ImportUtil.formatName(fileLine.getData(lastName2Index));
            String clubName = ImportUtil.formatName(fileLine.getData(clubNameIndex));
            if (firstName1 == null || firstName1.isEmpty() || lastName1 == null || lastName1.isEmpty() || firstName2 == null || firstName2.isEmpty() || lastName2 == null || lastName2.isEmpty() || clubName == null || clubName.isEmpty()) continue;
            Club club = this.clubManager.getActiveClubByName(competition, clubName);
            if (club == null) {
                errors.put(firstName1 + " " + lastName1 + "-" + firstName2 + " " + lastName2 + " / " + clubName, DataImportException.ErrorType.ClubNotFound);
                continue;
            }
            String categoryName = fileLine.getData(categoryNameIndex);
            Category category = null;
            if (categoryName != null && !categoryName.trim().isEmpty() && (c = this.categoryManager.getActiveCategoryByName(competition, categoryName = categoryName.trim())) != null) {
                if (c instanceof DuoCategory) {
                    category = c;
                } else if (c.getType() == Category.Type.CUSTOM) {
                    category = c;
                }
            }
            if (category == null) {
                errors.put(firstName1 + " " + lastName1 + "-" + firstName2 + " " + lastName2 + " / " + clubName + " / " + categoryName, DataImportException.ErrorType.CategoryNotFound);
            }
            if ((shortName = fileLine.getData(shortNameIndex)) == null || shortName.trim().isEmpty()) {
                shortName = lastName1 + "-" + lastName2;
            }
            Integer yearOfBirth1 = null;
            if (fileLine.getData(yearOfBirth1Index) != null && !fileLine.getData(yearOfBirth1Index).trim().isEmpty()) {
                try {
                    yearOfBirth1 = Integer.parseInt(fileLine.getData(yearOfBirth1Index).trim());
                }
                catch (Exception e) {
                    log.warn("Error while parsing year of birth 1 for competitor {} {}", (Object)lastName1, (Object)lastName2);
                }
            }
            Integer yearOfBirth2 = null;
            if (fileLine.getData(yearOfBirth2Index) != null && !fileLine.getData(yearOfBirth2Index).trim().isEmpty()) {
                try {
                    yearOfBirth2 = Integer.parseInt(fileLine.getData(yearOfBirth2Index).trim());
                }
                catch (Exception e) {
                    log.warn("Error while parsing year of birth 2 for competitor {} {}", (Object)lastName1, (Object)lastName2);
                }
            }
            if ((coupleCompetitor = this.competitorManager.getActiveCoupleCompetitorByNameAndClub(competition, firstName1, lastName1, firstName2, lastName2, club)) == null) {
                coupleCompetitor = new CoupleCompetitor();
                coupleCompetitor.setName1(firstName1);
                coupleCompetitor.setSurname1(lastName1);
                coupleCompetitor.setName2(firstName2);
                coupleCompetitor.setSurname2(lastName2);
                coupleCompetitor.setShortName(shortName);
                coupleCompetitor.setClub(club);
                coupleCompetitor.setYearOfBirth1(yearOfBirth1);
                coupleCompetitor.setYearOfBirth2(yearOfBirth2);
                coupleCompetitor.setStatus(Competitor.Status.ACTIVE);
                coupleCompetitor.setType(Competitor.Type.COUPLE);
                coupleCompetitor.setCompetition(competition);
            }
            if (!coupleCompetitors.containsKey(competitorKey = firstName1 + " " + lastName1 + "-" + firstName2 + " " + lastName2 + "/" + clubName)) {
                coupleCompetitors.put(competitorKey, coupleCompetitor);
                competitors.add((Competitor)coupleCompetitor);
            } else {
                coupleCompetitor = (CoupleCompetitor)coupleCompetitors.get(competitorKey);
            }
            if (coupleCompetitor.getCategories() == null) {
                coupleCompetitor.setCategories(new LinkedList());
            }
            if (category == null) continue;
            coupleCompetitor.getCategories().add(category);
        }
        return competitors;
    }

    public void importCompetitors(Competition competition, List<Competitor> competitors) throws Exception {
        for (Competitor competitor : competitors) {
            List categories = competitor.getCategories();
            if (competitor.getCompetitorId() == null) {
                competitor = this.competitorManager.createCompetitor(competitor);
            }
            for (Category category : categories) {
                this.competitorManager.addCompetitorToCategory(competitor, category);
            }
        }
    }

    public byte[] exportCompetitors(FileType fileType, List<Competitor> competitors, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        LinkedList<String[]> fileContent = new LinkedList<String[]>();
        fileContent.add(header);
        for (Competitor competitor : competitors) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
            List categories = this.categoryManager.getCategoriesForCompetitor(competitor);
            if (categories.isEmpty()) {
                fileContent.add(new String[]{coupleCompetitor.getName1(), coupleCompetitor.getSurname1(), coupleCompetitor.getName2(), coupleCompetitor.getSurname2(), coupleCompetitor.getClub().getName(), "", coupleCompetitor.getShortName(), coupleCompetitor.getYearOfBirth1() != null ? coupleCompetitor.getYearOfBirth1().toString() : "", coupleCompetitor.getYearOfBirth2() != null ? coupleCompetitor.getYearOfBirth2().toString() : ""});
                continue;
            }
            for (Category category : categories) {
                fileContent.add(new String[]{coupleCompetitor.getName1(), coupleCompetitor.getSurname1(), coupleCompetitor.getName2(), coupleCompetitor.getSurname2(), coupleCompetitor.getClub().getName(), category.getName(), coupleCompetitor.getShortName(), coupleCompetitor.getYearOfBirth1() != null ? coupleCompetitor.getYearOfBirth1().toString() : "", coupleCompetitor.getYearOfBirth2() != null ? coupleCompetitor.getYearOfBirth2().toString() : ""});
            }
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, (String[][])fileContent.toArray((T[])new String[0][0]));
        return buffer.toByteArray();
    }
}

