/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.semafor.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import si.nevensrok.jtekma.semafor.common.SemaphoreData;
import si.nevensrok.jtekma.semafor.gui.SemaphoreWindow;

public class WindowKeyListener
implements KeyListener,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowKeyListener.class);
    private ApplicationContext applicationContext;
    private SemaphoreWindow semaphoreWindow;
    private SemaphoreData semaphoreData;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.semaphoreData.getLocale());
    }

    public void setSemaphoreWindow(SemaphoreWindow semaphoreWindow) {
        this.semaphoreWindow = semaphoreWindow;
    }

    public void setSemaphoreData(SemaphoreData semaphoreData) {
        this.semaphoreData = semaphoreData;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        LOGGER.trace("Key pressed: [{}] - [{}]", (Object)e.getKeyCode(), (Object)Character.valueOf(e.getKeyChar()));
        if (e.getKeyCode() == 27 || e.getKeyCode() == 88) {
            if (JOptionPane.showConfirmDialog(this.semaphoreWindow, this.getLanguageText("text.exit"), this.getLanguageText("title.confirmation"), 1, 2) == 0) {
                if (this.applicationContext instanceof AbstractApplicationContext) {
                    AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)this.applicationContext;
                    abstractApplicationContext.close();
                } else {
                    LOGGER.warn("Can't destroy application context. Stopping java proccess");
                }
                System.exit(0);
            }
        } else if (e.getKeyCode() == 82) {
            this.semaphoreWindow.resetWindowLocation();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

