/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.fw;

import java.util.List;
import si.nevensrok.jtekma.common.fightinfo.CurrentMatchInfo;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.fightinfo.fw.FightInfoServiceClient;
import si.nevensrok.jtekma.fightinfo.gui.FightInfoWindow;
import si.nevensrok.jtekma.services.common.Credentials;

public class FightInfoManager {
    private Credentials credentials = null;
    private FightInfoServiceClient fightInfoService;
    private FightInfoWindow fightInfoWindow;

    public void setFightInfoService(FightInfoServiceClient fightInfoService) {
        this.fightInfoService = fightInfoService;
    }

    public void setFightInfoWindow(FightInfoWindow fightInfoWindow) {
        this.fightInfoWindow = fightInfoWindow;
    }

    public boolean connect(Credentials credentials) {
        this.credentials = null;
        this.fightInfoService.setup(credentials.getUrl());
        boolean loginSuccessfull = this.fightInfoService.checkLogin(credentials);
        if (loginSuccessfull) {
            this.credentials = credentials;
        }
        return loginSuccessfull;
    }

    public void disconnect() {
        this.credentials = null;
    }

    public void fetchCurrentFightData() {
        Credentials credentials = this.credentials;
        if (credentials == null) {
            return;
        }
        List<CurrentMatchInfo> currentMatchInfoList = this.fightInfoService.getCurrentFightsInfo(credentials);
        this.fightInfoWindow.updateFightLineTable(currentMatchInfoList);
    }

    public void fetchNextFightsData() {
        Credentials credentials = this.credentials;
        if (credentials == null) {
            return;
        }
        TatamiFightData tatamiFightData = this.fightInfoService.getTatamiFightData(credentials);
        this.fightInfoWindow.updateTatamiNextFights(tatamiFightData);
    }
}

