/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.geolocation.google;

import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.geolocation.Address;
import si.nevensrok.common.geolocation.AddressGeoLocator;
import si.nevensrok.common.geolocation.GeoCoordinates;
import si.nevensrok.common.geolocation.google.GoogleResult;
import si.nevensrok.common.restclient.RestClient;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;

public class GoogleAddressGeoLocator
implements AddressGeoLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAddressGeoLocator.class);
    private String apiUrl = "https://maps.googleapis.com/maps/api/geocode/json";
    private String apiKey = null;
    private RestClient restClient = new RestClient();
    private ObjectMapper objectMapper = new ObjectMapper();

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public GoogleAddressGeoLocator() {
        this.objectMapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    @Override
    public GeoCoordinates findGeoCoordinates(Address address) {
        String addressString = address.getStreet() + " " + address.getStreetNumber() + ", " + address.getPostalCode().toString() + " " + address.getPostName();
        RestRequest restRequest = RestRequest.get(this.getApiUrl());
        restRequest.setQueryParameter("key", this.getApiKey());
        restRequest.setQueryParameter("address", addressString);
        restRequest.setQueryParameter("sensor", "false");
        RestResponse restResponse = this.restClient.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            throw new RuntimeException("Invalid server response " + restResponse.getResponseCode());
        }
        try {
            GoogleResult result = (GoogleResult)this.objectMapper.readValue(restResponse.getBody(), GoogleResult.class);
            if (result.getResults().isEmpty()) {
                throw new RuntimeException("Search for coordinates returned no results");
            }
            if (result.getResults().size() > 1) {
                LOGGER.warn("Search for coordinates returned multiple results. Using first one");
            }
            GeoCoordinates geoCoordinates = new GeoCoordinates();
            geoCoordinates.setLatitude(result.getResults().get(0).getGeometry().getLocation().getLat());
            geoCoordinates.setLongitude(result.getResults().get(0).getGeometry().getLocation().getLng());
            return geoCoordinates;
        }
        catch (Exception e) {
            LOGGER.error("Error reading response", (Throwable)e);
            return null;
        }
    }
}

