/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiOnSemaphore;
import si.nevensrok.jtekma.server.dl.dto.tatami.SemaphoreDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.TatamiDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.TatamiOnSemaphoreDTO;

public class SemaphoreDAO
extends ExtendedDao<Long, SemaphoreDTO, Semaphore> {
    public SemaphoreDAO() {
        super(SemaphoreDTO.class, Semaphore.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("semaphoreId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("password")) {
            return "password";
        }
        if (fieldName.equalsIgnoreCase("displayRows")) {
            return "displayRows";
        }
        if (fieldName.equalsIgnoreCase("competition")) {
            return "competition.id";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public void updateSemaphorePassword(Semaphore semaphore) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update SemaphoreDTO set password=");
        sql.append(paramsBinder.addParam(semaphore.getPassword()));
        sql.append(" where id=");
        sql.append(paramsBinder.addParam(semaphore.getSemaphoreId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Semaphore getActiveSemaphoreByName(Competition competition, String name) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select semaphore from SemaphoreDTO as semaphore where semaphore.competition.competitionId=");
        sql.append(paramsBinder.addParam(competition.getCompetitionId()));
        sql.append(" and UPPER(semaphore.name)=UPPER(");
        sql.append(paramsBinder.addParam(name));
        sql.append(")");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        SemaphoreDTO semaphoreDTO = (SemaphoreDTO)SemaphoreDAO.getSingleResult((Query)query);
        Semaphore semaphore = null;
        if (semaphoreDTO != null) {
            semaphore = (Semaphore)this.getAdapterPool().create(Semaphore.class, (Object)semaphoreDTO);
        }
        this.flush();
        return semaphore;
    }

    public Set<TatamiOnSemaphore> getTatamisForSemaphore(Semaphore semaphore) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select tatamiOnSemaphore,tatamiOnSemaphore.tatamiOnSemaphoreKey.tatami from TatamiOnSemaphoreDTO as tatamiOnSemaphore where tatamiOnSemaphore.tatamiOnSemaphoreKey.semaphore.id=");
        sql.append(paramsBinder.addParam(semaphore.getSemaphoreId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        List list = query.getResultList();
        HashSet<TatamiOnSemaphore> tatamiOnSemaphores = new HashSet<TatamiOnSemaphore>();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            TatamiOnSemaphoreDTO tatamiOnSemaphoreDTO = (TatamiOnSemaphoreDTO)parts[0];
            TatamiOnSemaphore tatamiOnSemaphore = new TatamiOnSemaphore();
            tatamiOnSemaphore.setSemaphore(semaphore);
            tatamiOnSemaphore.setTatami((Tatami)this.getAdapterPool().getAdapter(TatamiDTO.class, Tatami.class).create((Object)((TatamiDTO)parts[1])));
            tatamiOnSemaphore.setOrderNum(tatamiOnSemaphoreDTO.getOrderNum());
            tatamiOnSemaphores.add(tatamiOnSemaphore);
        }
        this.flush();
        return tatamiOnSemaphores;
    }

    public void setTatamisForSemaphore(Semaphore semaphore, Set<TatamiOnSemaphore> tatamiOnSemaphores) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from TatamiOnSemaphoreDTO where tatamiOnSemaphoreKey.semaphore.id=");
        sql.append(paramsBinder.addParam(semaphore.getId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        SemaphoreDTO semaphoreDTO = new SemaphoreDTO();
        semaphoreDTO.setSemaphoreId(semaphore.getSemaphoreId());
        for (TatamiOnSemaphore tatamiOnSemaphore : tatamiOnSemaphores) {
            TatamiDTO tatamiDTO = new TatamiDTO();
            tatamiDTO.setTatamiId(tatamiOnSemaphore.getTatami().getTatamiId());
            TatamiOnSemaphoreDTO tatamiOnSemaphoreDTO = new TatamiOnSemaphoreDTO(semaphoreDTO, tatamiDTO);
            tatamiOnSemaphoreDTO.setOrderNum(tatamiOnSemaphore.getOrderNum());
            this.getCurrentSession().save((Object)tatamiOnSemaphoreDTO);
        }
        this.flush();
    }

    public void deleteSemaphore(Semaphore semaphore) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from TatamiOnSemaphoreDTO where tatamiOnSemaphoreKey.semaphore.id=");
        sql.append(paramsBinder.addParam(semaphore.getId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        paramsBinder = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("delete from SemaphoreDTO where semaphoreId=");
        sql.append(paramsBinder.addParam(semaphore.getId()));
        query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Semaphore getSemaphoreForActiveCompetition(String name) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select semaphore from SemaphoreDTO as semaphore where semaphore.name=");
        sql.append(paramsBinder.addParam(name));
        sql.append(" and semaphore.competition.status=");
        sql.append(paramsBinder.addParam((Object)Competition.Status.ACTIVE));
        sql.append(" order by semaphore.competition.competitonDate desc");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        SemaphoreDTO semaphoreDTO = (SemaphoreDTO)SemaphoreDAO.getSingleResult((Query)query);
        Semaphore semaphore = null;
        if (semaphoreDTO != null) {
            semaphore = (Semaphore)this.getAdapterPool().create(Semaphore.class, (Object)semaphoreDTO);
        }
        this.flush();
        return semaphore;
    }
}

