/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.textrenderer.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.common.textrenderer.AbstractTextRenderer;
import si.nevensrok.common.textrenderer.TextRenderException;
import si.nevensrok.common.textrenderer.TextRenderer;
import si.nevensrok.common.textrenderer.velocity.ContextData;
import si.nevensrok.common.velocity.VelocityEngine;
import si.nevensrok.common.velocity.VelocityEngineImpl;

public class VelocityTextRenderer
extends AbstractTextRenderer
implements TextRenderer,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(VelocityTextRenderer.class);
    private VelocityEngine velocityEngine;
    private Map<String, Object> toolbox;
    private List<String> macroLibraries;

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public Map<String, Object> getToolbox() {
        return this.toolbox;
    }

    public void setToolbox(Map<String, Object> toolbox) {
        this.toolbox = toolbox;
    }

    public List<String> getMacroLibraries() {
        return this.macroLibraries;
    }

    public void setMacroLibraries(List<String> macroLibraries) {
        this.macroLibraries = macroLibraries;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.velocityEngine == null) {
            log.debug("Initializing velocity engine");
            this.velocityEngine = new VelocityEngineImpl();
            ((VelocityEngineImpl)this.velocityEngine).afterPropertiesSet();
            log.debug("Velocity engine initialized");
        }
        if (this.macroLibraries == null) {
            this.macroLibraries = new LinkedList<String>();
            this.macroLibraries.add("/si/nevensrok/common/textrenderer/velocity/springMessage.vm");
        }
    }

    @Override
    public String renderText(String file, Map<String, Object> data, Locale locale) throws TextRenderException {
        log.debug("Using template: {}", (Object)file);
        Template template = this.getVelocityEngine().getTemplate(file);
        if (template == null) {
            throw new TextRenderException("Template for path '" + file + "' not found");
        }
        VelocityContext context = new VelocityContext();
        for (String string : data.keySet()) {
            context.put(string, data.get(string));
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ContextData contextData = new ContextData();
        contextData.setLocale(locale);
        contextData.setMessageSource(this.getMessageSource());
        context.put("contextData", (Object)contextData);
        if (this.getToolbox() != null) {
            for (String key : this.toolbox.keySet()) {
                Object tool = this.toolbox.get(key);
                context.put(key, tool);
            }
        }
        StringWriter stringWriter = new StringWriter();
        template.merge((Context)context, (Writer)stringWriter, this.getMacroLibraries());
        return stringWriter.toString();
    }
}

