/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QRPhoneCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = -6931452084313018647L;
    private String phone;

    public QRPhoneCode() {
    }

    public QRPhoneCode(String phone) {
        this.phone = phone;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    public String getCodeText() {
        return "tel:" + this.phone;
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.PHONE;
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            if (!text.startsWith("tel:")) {
                throw new QRCodeException("Not a phone QR code!");
            }
            this.phone = text.substring(4, text.length());
        }
        catch (QRCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QRPhoneCode [phone=" + this.phone + "]";
    }
}

