/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.formatter;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.format.AnnotationFormatterFactory;

public abstract class AbstractFormatterFactory<T extends Annotation>
implements AnnotationFormatterFactory<T>,
ApplicationContextAware {
    private final Set<Class<?>> fieldTypes;
    private ApplicationContext applicationContext;

    public AbstractFormatterFactory(Class<?>[] classes) {
        HashSet rawFieldTypes = new HashSet();
        for (Class<?> clazz : classes) {
            rawFieldTypes.add(clazz);
        }
        this.fieldTypes = Collections.unmodifiableSet(rawFieldTypes);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Set<Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    public String getLocalizedMessage(String messageKey, Locale locale) {
        if (messageKey.startsWith("{") && messageKey.endsWith("}")) {
            messageKey = messageKey.substring(1, messageKey.length() - 1);
            return this.applicationContext.getMessage(messageKey, null, messageKey, locale);
        }
        return messageKey;
    }
}

