/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.systemsettings;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.CompetitionRole;
import si.nevensrok.jtekma.common.system.Role;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.systemsettings.CompetitionRoleModel;
import si.nevensrok.jtekma.server.web.controllers.systemsettings.UserModel;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/system-settings/users"})
@SessionAttributes(value={"userListFilter"})
public class UsersController
extends CoreController {
    public Map<String, String> getStatusTypes(Locale locale) {
        LinkedHashMap<String, String> categoryTypes = new LinkedHashMap<String, String>();
        categoryTypes.put(User.Status.ACTIVE.name(), this.getLanguageText(locale, "users.type." + User.Status.ACTIVE.name()));
        categoryTypes.put(User.Status.INACTIVE.name(), this.getLanguageText(locale, "users.type." + User.Status.INACTIVE.name()));
        return categoryTypes;
    }

    @ModelAttribute(value="usersActive")
    public Boolean getUsersActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="userListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="userListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("username", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        GroupFilter statusFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)statusFilter);
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)User.Status.ACTIVE));
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)User.Status.INACTIVE));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("username", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getUserManager().findUsers((DataFilter)dataFilter);
        model.addAttribute("users", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "users.text.added"));
        } else if (messageCode == 2) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "users.text.updated"));
        } else if (messageCode == 3) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "users.text.deleted"));
        }
        return "system-settings/user-list";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="user") UserModel userModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        model.addAttribute("userStatuses", this.getStatusTypes(RequestContextUtils.getLocale((HttpServletRequest)request)));
        return "system-settings/user-edit";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="user") @Valid UserModel userModel, BindingResult bindingResult) {
        if (userModel.getUsername() == null || userModel.getUsername().isEmpty()) {
            bindingResult.rejectValue("username", "common.error.dataNotEntered");
        } else if (this.getManagersList().getUserManager().getUserByUsername(userModel.getUsername()) != null) {
            bindingResult.rejectValue("username", "users.error.usernameTaken");
        }
        if (userModel.getPassword() == null || userModel.getPassword().isEmpty()) {
            bindingResult.rejectValue("password", "common.error.dataNotEntered");
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, userModel, bindingResult);
        }
        User user = new User();
        ObjectUtil.copyNotNullProperties((Object)userModel, (Object)user);
        if (user.getIsSuperAdmin() == null) {
            user.setIsSuperAdmin(Boolean.FALSE);
        }
        user = this.getManagersList().getUserManager().createUser(user);
        return "redirect:/system-settings/users?messageCode=1";
    }

    @RequestMapping(value={"/edit/{userId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId, @ModelAttribute(value="user") UserModel userModel, BindingResult bindingResult) {
        User user = this.getManagersList().getUserManager().getById(userId);
        ObjectUtil.copyNotNullProperties((Object)user, (Object)userModel);
        model.addAttribute("userStatuses", this.getStatusTypes(RequestContextUtils.getLocale((HttpServletRequest)request)));
        return "system-settings/user-edit";
    }

    @RequestMapping(value={"/edit/{userId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId, @ModelAttribute(value="user") UserModel userModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, userId, userModel, bindingResult);
        }
        User user = this.getManagersList().getUserManager().getById(userId);
        ObjectUtil.copyNotNullProperties((Object)userModel, (Object)user);
        this.getManagersList().getUserManager().updateUser(user);
        user.setStatus(user.getStatus());
        user.setIsSuperAdmin(user.getIsSuperAdmin());
        this.getManagersList().getUserManager().updateUsersPasswordStatusAndSA(user);
        if (userModel.getPassword() != null && !userModel.getPassword().isEmpty()) {
            user.setPassword(userModel.getPassword());
            this.getManagersList().getUserManager().updateUsersPassword(user);
        }
        return "redirect:/system-settings/users?messageCode=2";
    }

    @RequestMapping(value={"/delete/{userId}"}, method={RequestMethod.GET})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId) {
        User user = this.getManagersList().getUserManager().getById(userId);
        user.setStatus(User.Status.DELETED);
        this.getManagersList().getUserManager().updateUsersPasswordStatusAndSA(user);
        return "redirect:/system-settings/users?messageCode=3";
    }

    @RequestMapping(value={"/roles/{userId}"})
    public String listRoles(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId) {
        User user = this.getManagersList().getUserManager().getById(userId);
        List competitionRoles = this.getManagersList().getUserManager().getRolesForUser(user);
        model.addAttribute("user", (Object)user);
        model.addAttribute("competitionRoles", (Object)competitionRoles);
        return "system-settings/user-roles";
    }

    private Map<Role, String> getRolesMap(Locale locale) {
        LinkedHashMap<Role, String> roles = new LinkedHashMap<Role, String>();
        roles.put(Role.ADMIN, this.getLanguageText(locale, "role.ADMIN"));
        roles.put(Role.MANAGER, this.getLanguageText(locale, "role.MANAGER"));
        roles.put(Role.LEADER, this.getLanguageText(locale, "role.LEADER"));
        roles.put(Role.VIEWER, this.getLanguageText(locale, "role.VIEWER"));
        return roles;
    }

    private Map<Long, String> getCompetitionsMap() {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.OR);
        dataFilter.setFilter((Filter)rootFilter);
        rootFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competition.Status.ACTIVE));
        rootFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competition.Status.FINISHED));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        LinkedHashMap<Long, String> competitions = new LinkedHashMap<Long, String>();
        competitions.put(0L, "");
        for (Competition competition : this.getManagersList().getCompetitionManager().find((DataFilter)dataFilter).getData()) {
            competitions.put(competition.getCompetitionId(), competition.getName());
        }
        return competitions;
    }

    @RequestMapping(value={"/roles/{userId}/add"}, method={RequestMethod.GET})
    public String addRole(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId, @ModelAttribute(value="competitionRole") CompetitionRoleModel competitionRoleModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        if (!bindingResult.hasErrors()) {
            competitionRoleModel.setRole(Role.VIEWER);
        }
        User user = this.getManagersList().getUserManager().getById(userId);
        model.addAttribute("user", (Object)user);
        model.addAttribute("competitions", this.getCompetitionsMap());
        model.addAttribute("roles", this.getRolesMap(RequestContextUtils.getLocale((HttpServletRequest)request)));
        return "system-settings/role-add";
    }

    @RequestMapping(value={"/roles/{userId}/add"}, method={RequestMethod.POST})
    public String addRolePost(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId, @ModelAttribute(value="competitionRole") @Valid CompetitionRoleModel competitionRoleModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.addRole(request, model, userId, competitionRoleModel, bindingResult);
        }
        User user = new User();
        user.setUserId(userId);
        Competition competition = new Competition();
        competition.setCompetitionId(competitionRoleModel.getCompetitionId());
        CompetitionRole competitionRole = new CompetitionRole();
        competitionRole.setUser(user);
        competitionRole.setCompetition(competition);
        competitionRole.setRole(competitionRoleModel.getRole());
        this.getManagersList().getUserManager().setCompetitionRole(competitionRole);
        return "redirect:/system-settings/users/roles/" + userId;
    }

    @RequestMapping(value={"/roles/{userId}/edit/{competitionId}"}, method={RequestMethod.GET})
    public String editRole(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId, @PathVariable(value="competitionId") Long competitionId, @ModelAttribute(value="competitionRole") CompetitionRoleModel competitionRoleModel, BindingResult bindingResult) {
        User user = this.getManagersList().getUserManager().getById(userId);
        Competition competition = new Competition();
        competition.setCompetitionId(competitionId);
        CompetitionRole currentCompetitionRole = this.getManagersList().getUserManager().getRoleForUser(user, competition);
        competitionRoleModel.setCompetitionId(currentCompetitionRole.getCompetition().getCompetitionId());
        competitionRoleModel.setRole(currentCompetitionRole.getRole());
        model.addAttribute("user", (Object)user);
        model.addAttribute("competitions", this.getCompetitionsMap());
        model.addAttribute("roles", this.getRolesMap(RequestContextUtils.getLocale((HttpServletRequest)request)));
        return "system-settings/role-add";
    }

    @RequestMapping(value={"/roles/{userId}/edit/{competitionId}"}, method={RequestMethod.POST})
    public String editRolePost(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId, @PathVariable(value="competitionId") Long competitionId, @ModelAttribute(value="competitionRole") CompetitionRoleModel competitionRoleModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.editRole(request, model, userId, competitionId, competitionRoleModel, bindingResult);
        }
        User user = new User();
        user.setUserId(userId);
        Competition competition = new Competition();
        competition.setCompetitionId(competitionId);
        CompetitionRole competitionRole = new CompetitionRole();
        competitionRole.setUser(user);
        competitionRole.setCompetition(competition);
        competitionRole.setRole(competitionRoleModel.getRole());
        this.getManagersList().getUserManager().setCompetitionRole(competitionRole);
        return "redirect:/system-settings/users/roles/" + userId;
    }

    @RequestMapping(value={"/roles/{userId}/delete/{competitionId}"})
    public String deleteRole(HttpServletRequest request, Model model, @PathVariable(value="userId") Long userId, @PathVariable(value="competitionId") Long competitionId) {
        User user = new User();
        user.setUserId(userId);
        Competition competition = new Competition();
        competition.setCompetitionId(competitionId);
        CompetitionRole competitionRole = new CompetitionRole();
        competitionRole.setUser(user);
        competitionRole.setCompetition(competition);
        this.getManagersList().getUserManager().removeCompetitionRole(competitionRole);
        return "redirect:/system-settings/users/roles/" + userId;
    }
}

