/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.matchupload.NextMatchUpload;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.NextMatchUploadModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/next-match-uploads"})
@SessionAttributes(value={"nextMatchUploadListFilter"})
public class NextMatchUploadController
extends CoreController {
    @ModelAttribute(value="nextMatchUploadsActive")
    public Boolean getNextMatchUploadsActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="nextMatchUploadListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.NEXTMATCHUPLOADEDIT);
    }

    @ModelAttribute(value="statusOptions")
    public Map<NextMatchUpload.Status, String> getStatusOptions(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<NextMatchUpload.Status, String> statusOptions = new LinkedHashMap<NextMatchUpload.Status, String>();
        statusOptions.put(NextMatchUpload.Status.ACTIVE, this.getLanguageText(locale, "nextMatchUpload.status.ACTIVE"));
        statusOptions.put(NextMatchUpload.Status.INACTIVE, this.getLanguageText(locale, "nextMatchUpload.status.INACTIVE"));
        return statusOptions;
    }

    @ModelAttribute(value="typeOptions")
    public Map<NextMatchUpload.ServerType, String> getTypeOptions(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<NextMatchUpload.ServerType, String> typeOptions = new LinkedHashMap<NextMatchUpload.ServerType, String>();
        for (NextMatchUpload.ServerType serverType : NextMatchUpload.ServerType.values()) {
            typeOptions.put(serverType, this.getLanguageText(locale, "nextMatchUpload.type." + serverType.name()));
        }
        return typeOptions;
    }

    @ModelAttribute(value="pageTemplateOptions")
    public Map<String, String> getPageTemplateOptions() {
        LinkedHashMap<String, String> pageTemplateOptions = new LinkedHashMap<String, String>();
        pageTemplateOptions.put("normal", "Normal");
        return pageTemplateOptions;
    }

    @ModelAttribute(value="pageLocaleOptions")
    public Map<String, String> getPageLocaleOptions(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<String, String> pageLocaleOptions = new LinkedHashMap<String, String>();
        pageLocaleOptions.put("en", this.getLanguageText(locale, "locale.english"));
        pageLocaleOptions.put("sl", this.getLanguageText(locale, "locale.slovenian"));
        return pageLocaleOptions;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="nextMatchUploadListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        NextMatchUpload example = new NextMatchUpload();
        example.setHostname("%" + searchFilter.getSearch().trim() + "%");
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("hostname", Sort.Field.Direction.ASC, false));
        dataFilter.getSort().addField(new Sort.Field("port", Sort.Field.Direction.ASC));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getNextMatchUploadManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("nextMatchUploads", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "nextMatchUpload.text.added"));
        } else if (messageCode == 2) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "nextMatchUpload.text.updated"));
        } else if (messageCode == 3) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "nextMatchUpload.text.deleted"));
        }
        return "data/next-match-upload-list";
    }

    @MethodRight(value={Right.NEXTMATCHUPLOADEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="nextMatchUpload") NextMatchUploadModel nextMatchUploadModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        if (!bindingResult.hasErrors()) {
            nextMatchUploadModel.setStatus(NextMatchUpload.Status.ACTIVE);
            nextMatchUploadModel.setServerType(NextMatchUpload.ServerType.FTP);
            nextMatchUploadModel.setPort(21);
            nextMatchUploadModel.setDelayInMinutes(5);
            nextMatchUploadModel.setPageTemplate("normal");
            nextMatchUploadModel.setPageLocale("en");
        }
        return "data/next-match-upload-edit";
    }

    @MethodRight(value={Right.NEXTMATCHUPLOADEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="nextMatchUpload") @Valid NextMatchUploadModel nextMatchUploadModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.add(request, model, nextMatchUploadModel, bindingResult);
        }
        NextMatchUpload nextMatchUpload = new NextMatchUpload();
        ObjectUtil.copyNotNullProperties((Object)nextMatchUploadModel, (Object)nextMatchUpload);
        nextMatchUpload.setUploadDelay(Long.valueOf(nextMatchUploadModel.getDelayInMinutes().longValue() * 60000L));
        nextMatchUpload.setCompetition(this.getUserData().getCompetition());
        nextMatchUpload = this.getManagersList().getNextMatchUploadManager().createNextMatchUpload(nextMatchUpload);
        return "redirect:/data/next-match-uploads?messageCode=1";
    }

    @MethodRight(value={Right.NEXTMATCHUPLOADEDIT})
    @RequestMapping(value={"/edit/{nextMatchUploadId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="nextMatchUploadId") Long nextMatchUploadId, @ModelAttribute(value="nextMatchUpload") NextMatchUploadModel nextMatchUploadModel, BindingResult bindingResult) {
        NextMatchUpload nextMatchUpload = this.getManagersList().getNextMatchUploadManager().getNextMatchUploadById(nextMatchUploadId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForNextMatchUpload(nextMatchUpload).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        if (!bindingResult.hasErrors()) {
            ObjectUtil.copyNotNullProperties((Object)nextMatchUpload, (Object)nextMatchUploadModel);
            nextMatchUploadModel.setDelayInMinutes((int)(nextMatchUpload.getUploadDelay() / 60000L));
        }
        return "data/next-match-upload-edit";
    }

    @MethodRight(value={Right.NEXTMATCHUPLOADEDIT})
    @RequestMapping(value={"/edit/{nextMatchUploadId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="nextMatchUploadId") Long nextMatchUploadId, @ModelAttribute(value="nextMatchUpload") @Valid NextMatchUploadModel nextMatchUploadModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, nextMatchUploadId, nextMatchUploadModel, bindingResult);
        }
        NextMatchUpload nextMatchUpload = this.getManagersList().getNextMatchUploadManager().getNextMatchUploadById(nextMatchUploadId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForNextMatchUpload(nextMatchUpload).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)nextMatchUploadModel, (Object)nextMatchUpload);
        nextMatchUpload.setUploadDelay(Long.valueOf(nextMatchUploadModel.getDelayInMinutes().longValue() * 60000L));
        nextMatchUpload = this.getManagersList().getNextMatchUploadManager().updateNextMatchUpload(nextMatchUpload);
        return "redirect:/data/next-match-uploads?messageCode=2";
    }

    @MethodRight(value={Right.NEXTMATCHUPLOADEDIT})
    @RequestMapping(value={"/delete/{nextMatchUploadId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="nextMatchUploadId") Long nextMatchUploadId) {
        NextMatchUpload nextMatchUpload = this.getManagersList().getNextMatchUploadManager().getNextMatchUploadById(nextMatchUploadId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForNextMatchUpload(nextMatchUpload).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getNextMatchUploadManager().deleteNextMatchUpload(nextMatchUpload);
        return "redirect:/data/next-match-uploads?messageCode=3";
    }
}

