/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.yubikey;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.yubikey.Crc16;
import si.nevensrok.common.yubikey.ModHexUtil;
import si.nevensrok.common.yubikey.OtpChecker;
import si.nevensrok.common.yubikey.OtpCodeData;
import si.nevensrok.common.yubikey.SecretKeyFetcher;

public class YubicoOtpChecker
implements OtpChecker,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(YubicoOtpChecker.class);
    private SecretKeyFetcher secretKeyFetcher;

    public void setSecretKeyFetcher(SecretKeyFetcher secretKeyFetcher) {
        this.secretKeyFetcher = secretKeyFetcher;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.secretKeyFetcher == null) {
            throw new IllegalArgumentException("Property 'secretKeyFetcher' is required");
        }
    }

    @Override
    public OtpCodeData checkCode(String otpCode) {
        try {
            OtpCodeData otpCodeData = new OtpCodeData();
            String publicId = otpCode.substring(0, otpCode.length() - 32);
            otpCodeData.setPublicId(publicId);
            String encryptedOtp = otpCode.substring(otpCode.length() - 32);
            byte[] encryptedOtpBytes = ModHexUtil.fromModhexString(encryptedOtp);
            byte[] secretKeyBytes = this.secretKeyFetcher.fetchSecretKey(publicId);
            if (secretKeyBytes == null) {
                throw new RuntimeException("Secret key not found");
            }
            if (secretKeyBytes.length != 16) {
                throw new RuntimeException("Secret key bytes length is invalid");
            }
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, secretKey);
            byte[] decryptedOtpBytes = cipher.doFinal(encryptedOtpBytes);
            byte[] bytes = new byte[6];
            System.arraycopy(decryptedOtpBytes, 0, bytes, 0, 6);
            otpCodeData.setPrivateId(bytes);
            bytes = new byte[2];
            System.arraycopy(decryptedOtpBytes, 6, bytes, 0, 2);
            int usageCounter = (bytes[1] << 8 & 0xFF00) + (bytes[0] & 0xFF);
            otpCodeData.setUsageCounter(usageCounter);
            bytes = new byte[3];
            System.arraycopy(decryptedOtpBytes, 8, bytes, 0, 3);
            long timeStamp = (bytes[2] << 16 & 0xFF0000) + (bytes[1] << 8 & 0xFF00) + (bytes[0] & 0xFF);
            otpCodeData.setTimeStamp(timeStamp);
            bytes = new byte[1];
            System.arraycopy(decryptedOtpBytes, 11, bytes, 0, 1);
            int sessionUsageCounter = bytes[0] & 0xFF;
            otpCodeData.setSessionUsageCounter(sessionUsageCounter);
            bytes = new byte[2];
            System.arraycopy(decryptedOtpBytes, 14, bytes, 0, 2);
            int crc16 = (bytes[1] << 8 & 0xFF00) + (bytes[0] & 0xFF);
            byte[] bytesToCheck = new byte[14];
            System.arraycopy(decryptedOtpBytes, 0, bytesToCheck, 0, 14);
            int calculatedCrc16 = Crc16.calculateCrc16(bytesToCheck);
            if (crc16 != calculatedCrc16) {
                throw new RuntimeException("CRC16 check failed");
            }
            return otpCodeData;
        }
        catch (Throwable e) {
            log.debug("Error cheking code", e);
            return null;
        }
    }
}

