/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.executor;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureCompletedSpy<V> {
    private Object result;
    private Throwable throwable;
    private boolean completed = false;

    public synchronized void setDone() {
        this.completed = true;
        this.notifyAll();
    }

    public synchronized void setResult(Object result) {
        this.completed = true;
        this.result = result;
        this.notifyAll();
    }

    public synchronized void setThrowable(Throwable throwable) {
        this.completed = true;
        this.throwable = throwable;
        this.notifyAll();
    }

    public synchronized V get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            this.wait();
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return (V)this.result;
    }

    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.completed) {
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return (V)this.result;
        }
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (!this.completed) {
            long waitTime = waitUntil - System.currentTimeMillis();
            if (waitTime <= 0L) {
                throw new TimeoutException();
            }
            this.wait(waitTime);
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return (V)this.result;
    }
}

