/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessageSender;
import si.nevensrok.common.utils.MachineInfoUtil;
import si.nevensrok.common.utils.ObjectUtil;

public class UdpBroadcastMessageSender
implements NetworkMessageSender,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UdpBroadcastMessageSender.class);
    private String[] addresses;
    private Integer port;
    private String[] devices = null;
    private DatagramSocket socket = null;
    private Object senderMonitor = new Object();

    public void setAddress(String address) {
        this.addresses = new String[]{address};
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String[] getDevices() {
        return this.devices;
    }

    public void setDevices(String[] devices) {
        this.devices = devices;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        if (this.addresses == null) {
            LinkedList<String> addressList = new LinkedList<String>();
            for (NetworkInterface networkInterface : MachineInfoUtil.getActiveNetworkInterfaces()) {
                if (!this.isDeviceOnList(networkInterface.getName(), networkInterface.getInterfaceAddresses())) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress broadcastAddress = interfaceAddress.getBroadcast();
                    if (broadcastAddress == null) continue;
                    addressList.add(broadcastAddress.getHostAddress());
                }
            }
            this.addresses = addressList.toArray(new String[addressList.size()]);
        }
        log.debug("Connecting to UDP on multiple addresses on port {}", (Object)this.port);
        try {
            this.socket = new DatagramSocket();
            this.socket.setBroadcast(true);
        }
        catch (Exception e) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new NetworkException("Error connecting to UDP on multiple addresses", e);
        }
    }

    public void destroy() throws Exception {
        log.debug("Disconnecting from multiple addresses on port {}", (Object)this.port);
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sendMessage(Object object) throws NetworkException {
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(byte[] data) throws NetworkException {
        if (this.socket == null) {
            throw new NetworkException("Socket is closed");
        }
        for (String address : this.addresses) {
            try {
                DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName(address), this.port);
                if (log.isTraceEnabled()) {
                    log.trace("Sending message to [{}]:{}, message data: {}", new Object[]{address, this.port, data});
                }
                Object object = this.senderMonitor;
                synchronized (object) {
                    this.socket.send(packet);
                }
            }
            catch (Exception e) {
                throw new NetworkException("Error sending message", e);
            }
        }
    }

    private boolean isDeviceOnList(String name, List<InterfaceAddress> addressList) {
        if (this.devices == null) {
            return true;
        }
        for (String device : this.devices) {
            if (device.equalsIgnoreCase(name)) {
                return true;
            }
            for (InterfaceAddress interfaceAddress : addressList) {
                if (interfaceAddress.getAddress() == null || !device.equalsIgnoreCase(interfaceAddress.getAddress().getHostAddress())) continue;
                return true;
            }
        }
        return false;
    }
}

