/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.bccert.BcCertificateUtil;
import si.nevensrok.common.ssl.BcCertificateRepository;
import si.nevensrok.common.ssl.BcRevokedCertificateChecker;

public class BcCertificateChainVerifier {
    private static final Logger log = LoggerFactory.getLogger(BcCertificateChainVerifier.class);
    private boolean checkDate = true;
    private boolean checkSigningFlag = true;
    private boolean noCaCheck = false;
    private Date[] dates = new Date[]{Calendar.getInstance().getTime()};
    private TlsCertificate[] certificateChain;
    private BcRevokedCertificateChecker revokedCertificateChecker = null;
    private List<Certificate> certificateAuthorities = new LinkedList<Certificate>();
    private BcCertificateRepository certificateRepository;

    public BcCertificateChainVerifier withCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
        return this;
    }

    public BcCertificateChainVerifier withCheckSigningFlag(boolean checkSigningFlag) {
        this.checkSigningFlag = checkSigningFlag;
        return this;
    }

    public BcCertificateChainVerifier withNoCaCheck(boolean noCaCheck) {
        this.noCaCheck = noCaCheck;
        return this;
    }

    public BcCertificateChainVerifier withDates(Date[] dates) {
        this.dates = dates;
        return this;
    }

    public BcCertificateChainVerifier withDates(List<Date> dates) {
        this.dates = dates.toArray(new Date[dates.size()]);
        return this;
    }

    public BcCertificateChainVerifier withDate(Date date) {
        this.dates = new Date[]{date};
        return this;
    }

    public BcCertificateChainVerifier withCalendars(Calendar[] dates) {
        this.dates = new Date[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            this.dates[i] = dates[i].getTime();
        }
        return this;
    }

    public BcCertificateChainVerifier withCalendars(List<Calendar> dates) {
        return this.withCalendars(dates.toArray(new Calendar[dates.size()]));
    }

    public BcCertificateChainVerifier withCalendar(Calendar date) {
        this.dates = new Date[]{date.getTime()};
        return this;
    }

    public BcCertificateChainVerifier withCertificateChain(TlsCertificate[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public BcCertificateChainVerifier withCertificateChain(List<TlsCertificate> certificateChain) {
        this.certificateChain = certificateChain.toArray(new TlsCertificate[certificateChain.size()]);
        return this;
    }

    public BcCertificateChainVerifier withCertificate(TlsCertificate ... certificate) {
        this.certificateChain = certificate;
        return this;
    }

    public BcCertificateChainVerifier withCertificates(Collection<TlsCertificate> certificates) {
        this.certificateChain = certificates.toArray(new TlsCertificate[certificates.size()]);
        return this;
    }

    public BcCertificateChainVerifier withRevokedCertificateChecker(BcRevokedCertificateChecker revokedCertificateChecker) {
        this.revokedCertificateChecker = revokedCertificateChecker;
        return this;
    }

    public BcCertificateChainVerifier withCertificateAuthorities(Collection<Certificate> certificateAuthorities) {
        if (certificateAuthorities != null) {
            this.certificateAuthorities.addAll(certificateAuthorities);
        }
        return this;
    }

    public BcCertificateChainVerifier withCertificateAuthority(Certificate ... certificateAuthority) {
        for (Certificate cert : certificateAuthority) {
            this.certificateAuthorities.add(cert);
        }
        return this;
    }

    public BcCertificateChainVerifier withCertificateRepository(BcCertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
        return this;
    }

    public void check() throws CertificateException {
        if (this.certificateChain == null || this.certificateChain.length < 1) {
            throw new CertificateException("Certificate chain empty");
        }
        Certificate[] chain = new Certificate[this.certificateChain.length];
        try {
            for (int i = 0; i < this.certificateChain.length; ++i) {
                chain[i] = Certificate.getInstance((Object)this.certificateChain[i].getEncoded());
            }
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
        if (this.checkDate) {
            for (Certificate certificate : chain) {
                Date[] dateArray = this.dates;
                int n = dateArray.length;
                for (int i = 0; i < n; ++i) {
                    Date date = dateArray[i];
                    this.checkCertificateDate(certificate, date);
                }
            }
        }
        for (Certificate certificate : chain) {
            this.checkRevoked(certificate);
        }
        try {
            for (int i = 0; i < this.certificateChain.length - 1; ++i) {
                if (this.checkSigningFlag && !BcCertificateUtil.isUsedForSigning(chain[i + 1])) {
                    throw new CertificateException("Certificate is not verified for signing");
                }
                this.verifyCertificate(chain[i], chain[i + 1]);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException("Certificate chain is not valid", e);
        }
        if (this.noCaCheck) {
            return;
        }
        if (this.certificateRepository != null) {
            try {
                for (String alias : this.certificateRepository.getAliases()) {
                    try {
                        Certificate certificateAuthority = this.certificateRepository.getCertificate(alias);
                        if (this.checkDate) {
                            for (Date date : this.dates) {
                                this.checkCertificateDate(certificateAuthority, date);
                            }
                        }
                        this.checkRevoked(certificateAuthority);
                        this.verifyCertificate(chain[this.certificateChain.length - 1], certificateAuthority);
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception e) {
                log.trace("Error checking system CA keystore", (Throwable)e);
            }
        }
        for (Certificate certificateAuthority : this.certificateAuthorities) {
            try {
                if (this.checkDate) {
                    for (Date date : this.dates) {
                        this.checkCertificateDate(certificateAuthority, date);
                    }
                }
                this.checkRevoked(certificateAuthority);
                this.verifyCertificate(chain[this.certificateChain.length - 1], certificateAuthority);
                return;
            }
            catch (Exception exception) {
            }
        }
        throw new CertificateException("Certificate is not trust worthy");
    }

    protected void checkRevoked(Certificate certificate) throws CertificateException {
        if (this.revokedCertificateChecker != null && this.revokedCertificateChecker.isCertificateRevoked(certificate)) {
            throw new CertificateException("Certificate revoked");
        }
    }

    protected void checkCertificateDate(Certificate certificate, Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        BcCertificateUtil.checkCertificateDate(certificate, date);
    }

    protected void verifyCertificate(Certificate certificate, Certificate validateWith) throws CertificateException, InvalidKeyException, SignatureException, IOException {
        BcCertificateUtil.verifyCertificate(certificate, validateWith);
    }
}

