/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.monitor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.monitor.AbstractMonitorLock;
import si.nevensrok.common.monitor.LockStatus;

public class RuntimeMonitorLock
extends AbstractMonitorLock {
    private static final Logger log = LoggerFactory.getLogger(RuntimeMonitorLock.class);
    private Map<String, Date> locks = new HashMap<String, Date>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addLock(String monitor, Date lockDeadline) {
        Map<String, Date> map = this.locks;
        synchronized (map) {
            if (this.locks.containsKey(monitor)) {
                return false;
            }
            this.locks.put(monitor, lockDeadline);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLock(String monitor) {
        Map<String, Date> map = this.locks;
        synchronized (map) {
            this.locks.remove(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpiredLocks() {
        log.trace("Removing expired locks");
        Map<String, Date> map = this.locks;
        synchronized (map) {
            for (Map.Entry<String, Date> entry : new ArrayList<Map.Entry<String, Date>>(this.locks.entrySet())) {
                Date date = entry.getValue();
                if (date == null || date.getTime() >= System.currentTimeMillis()) continue;
                log.trace("Removing expired lock [{}] with expire time [{}]", (Object)entry.getKey(), (Object)entry.getValue());
                this.locks.remove(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockStatus getLockStatus(String monitor) {
        Map<String, Date> map = this.locks;
        synchronized (map) {
            if (!this.locks.containsKey(monitor)) {
                return null;
            }
            Date lockDeadline = this.locks.get(monitor);
            return new LockStatus(lockDeadline);
        }
    }
}

