/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.fightinfo.FightInfo;
import si.nevensrok.jtekma.server.dl.dto.fightinfo.FightInfoDTO;

public class FightInfoDAO
extends ExtendedDao<Long, FightInfoDTO, FightInfo> {
    public FightInfoDAO() {
        super(FightInfoDTO.class, FightInfo.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "fightInfoId";
        }
        if (fieldName.equalsIgnoreCase("fightInfoId")) {
            return "fightInfoId";
        }
        if (fieldName.equalsIgnoreCase("username")) {
            return "username";
        }
        if (fieldName.equalsIgnoreCase("password")) {
            return "password";
        }
        if (fieldName.equalsIgnoreCase("competition")) {
            return "competition.competitionId";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public void updateFightInfoPassword(FightInfo fightInfo) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update FightInfoDTO set password=");
        sql.append(paramsBinder.addParam(fightInfo.getPassword()));
        sql.append(" where fightInfoId=");
        sql.append(paramsBinder.addParam(fightInfo.getFightInfoId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public FightInfo getFightInfoForActiveCompetition(String username) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select fightInfo from FightInfoDTO as fightInfo where fightInfo.username=");
        sql.append(paramsBinder.addParam(username));
        sql.append(" and fightInfo.competition.status=");
        sql.append(paramsBinder.addParam((Object)Competition.Status.ACTIVE));
        sql.append(" order by fightInfo.competition.competitonDate desc");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        FightInfoDTO fightInfoDTO = (FightInfoDTO)FightInfoDAO.getSingleResult((Query)query);
        FightInfo fightInfo = null;
        if (fightInfoDTO != null) {
            fightInfo = (FightInfo)this.getAdapterPool().create(FightInfo.class, (Object)fightInfoDTO);
        }
        this.flush();
        return fightInfo;
    }

    public FightInfo getActiveFightInfoByName(Competition competition, String username) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select fightInfo from FightInfoDTO as fightInfo where fightInfo.competition.competitionId=");
        sql.append(paramsBinder.addParam(competition.getCompetitionId()));
        sql.append(" and UPPER(fightInfo.username)=UPPER(");
        sql.append(paramsBinder.addParam(username));
        sql.append(")");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        FightInfoDTO fightInfoDTO = (FightInfoDTO)FightInfoDAO.getSingleResult((Query)query);
        FightInfo fightInfo = null;
        if (fightInfoDTO != null) {
            fightInfo = (FightInfo)this.getAdapterPool().create(FightInfo.class, (Object)fightInfoDTO);
        }
        this.flush();
        return fightInfo;
    }
}

